/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.annotations.MappingAnnotations;
import org.eclipse.fordiac.ide.model.helpers.InterfaceListCopier;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationChannel;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.MappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceTypeFB;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.ErrorTypeEntry;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public final class FBNetworkHelper {
    public static FBNetwork copyFBNetWork(FBNetwork srcNetwork, InterfaceList destInterface) {
        FBNetwork dstNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        dstNetwork.getNetworkElements().addAll(EcoreUtil.copyAll(srcNetwork.getNetworkElements()));
        FBNetworkHelper.createConnections(srcNetwork, dstNetwork, destInterface);
        return dstNetwork;
    }

    public static FBNetwork copyCFBNetWork(FBNetwork srcNetwork, InterfaceList destInterface) {
        FBNetwork dstNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        FBNetworkAdapterLessCopier copier = new FBNetworkAdapterLessCopier();
        Collection result = copier.copyAll((Collection)srcNetwork.getNetworkElements());
        copier.copyReferences();
        dstNetwork.getNetworkElements().addAll(result);
        FBNetworkHelper.checkForAdapterFBs(dstNetwork, destInterface);
        FBNetworkHelper.createConnections(srcNetwork, dstNetwork, destInterface);
        return dstNetwork;
    }

    public static FBNetwork createResourceFBNetwork(FBNetwork resourceTypeNetwork, InterfaceList destInterface) {
        FBNetwork dstNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        FBNetworkHelper.createResourceTypeFBs(resourceTypeNetwork.getNetworkElements(), dstNetwork);
        FBNetworkHelper.createConnections(resourceTypeNetwork, dstNetwork, destInterface);
        return dstNetwork;
    }

    public static Stream<BlockFBNetworkElement> getBlockFBNetworkElementsFromList(Collection<FBNetworkElement> nwElements) {
        return nwElements.stream().filter(BlockFBNetworkElement.class::isInstance).map(BlockFBNetworkElement.class::cast);
    }

    private static void createResourceTypeFBs(EList<FBNetworkElement> networkElements, FBNetwork dstNetwork) {
        FBNetworkHelper.getBlockFBNetworkElementsFromList(networkElements).forEach(fb -> FBNetworkHelper.createResourceTypeFB(fb, dstNetwork));
    }

    private static void createResourceTypeFB(BlockFBNetworkElement srcFb, FBNetwork dstNetwork) {
        ResourceTypeFB copy = LibraryElementFactory.eINSTANCE.createResourceTypeFB();
        dstNetwork.getNetworkElements().add((Object)copy);
        copy.setTypeEntry(srcFb.getTypeEntry());
        copy.setName(srcFb.getName());
        InterfaceList interfaceList = InterfaceListCopier.copy(srcFb.getInterface(), true, false);
        copy.setInterface(interfaceList);
        copy.setPosition((Position)EcoreUtil.copy((EObject)srcFb.getPosition()));
    }

    private static void checkForAdapterFBs(FBNetwork dstNetwork, InterfaceList destInterface) {
        Stream.concat(destInterface.getPlugs().stream(), destInterface.getSockets().stream()).forEach(adp -> {
            boolean bl = dstNetwork.getNetworkElements().add((Object)adp.getAdapterFB());
        });
    }

    private static void createConnections(FBNetwork srcNetwork, FBNetwork dstNetwork, InterfaceList destInterface) {
        for (Connection connection : srcNetwork.getEventConnections()) {
            dstNetwork.getEventConnections().add((Object)((EventConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
        for (Connection connection : srcNetwork.getDataConnections()) {
            dstNetwork.getDataConnections().add((Object)((DataConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
        for (Connection connection : srcNetwork.getAdapterConnections()) {
            dstNetwork.getAdapterConnections().add((Object)((AdapterConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
    }

    private static Connection createConnection(FBNetwork srcNetwork, InterfaceList destInterface, FBNetwork dstNetwork, Connection connection) {
        Connection newConn = (Connection)EcoreUtil.copy((EObject)connection);
        newConn.setSource(FBNetworkHelper.getInterfaceElement(connection.getSource(), destInterface, dstNetwork, srcNetwork));
        newConn.setDestination(FBNetworkHelper.getInterfaceElement(connection.getDestination(), destInterface, dstNetwork, srcNetwork));
        return newConn;
    }

    /*
     * WARNING - void declaration
     */
    private static IInterfaceElement getInterfaceElement(IInterfaceElement ie, InterfaceList destInterface, FBNetwork dstNetwork, FBNetwork srcNetwork) {
        VarDeclaration varDeclaration;
        IInterfaceElement interfaceElement;
        if (ie.getBlockFBNetworkElement() == null || srcNetwork != ie.getBlockFBNetworkElement().getFbNetwork()) {
            interfaceElement = destInterface.getInterfaceElement(ie.getName());
        } else {
            void blockFbnel;
            FBNetworkElement element = dstNetwork.getElementNamed(ie.getBlockFBNetworkElement().getName());
            if (!(element instanceof BlockFBNetworkElement)) {
                return null;
            }
            BlockFBNetworkElement blockFBNetworkElement = (BlockFBNetworkElement)element;
            interfaceElement = blockFbnel.getInterfaceElement(ie.getName());
        }
        if (interfaceElement instanceof VarDeclaration && (varDeclaration = (VarDeclaration)interfaceElement).isInOutVar() && varDeclaration.isIsInput() != ie.isIsInput()) {
            return varDeclaration.getInOutVarOpposite();
        }
        return interfaceElement;
    }

    public static Position getTopLeftCornerOfFBNetwork(List<?> selection) {
        Assert.isNotNull(selection);
        double x = Double.MAX_VALUE;
        double y = Double.MAX_VALUE;
        for (Object sel : selection) {
            Object fb;
            if (sel instanceof EditPart) {
                EditPart ep = (EditPart)sel;
                v0 = ep.getModel();
            } else {
                v0 = fb = sel;
            }
            if (!(fb instanceof FBNetworkElement)) continue;
            FBNetworkElement fbnEL = (FBNetworkElement)fb;
            Position pos = fbnEL.getPosition();
            x = Math.min(x, pos.getX());
            y = Math.min(y, pos.getY());
        }
        Position pos = LibraryElementFactory.eINSTANCE.createPosition();
        pos.setX(x);
        pos.setY(y);
        return pos;
    }

    public static void moveFBNetworkByOffset(Iterable<FBNetworkElement> fbNetwork, double xOffset, double yOffset) {
        for (FBNetworkElement el : fbNetwork) {
            Position pos = LibraryElementFactory.eINSTANCE.createPosition();
            pos.setX(el.getPosition().getX() + xOffset);
            pos.setY(el.getPosition().getY() + yOffset);
            el.setPosition(pos);
        }
    }

    public static Position removeXYOffsetForFBNetwork(List<FBNetworkElement> fbNetwork) {
        Position offset = FBNetworkHelper.getTopLeftCornerOfFBNetwork(fbNetwork);
        FBNetworkHelper.moveFBNetworkByOffset(fbNetwork, -offset.getX(), -offset.getY());
        return offset;
    }

    public static void moveFBNetworkToDestination(List<FBNetworkElement> fbnetwork, Position destination) {
        Position current = FBNetworkHelper.getTopLeftCornerOfFBNetwork(fbnetwork);
        FBNetworkHelper.moveFBNetworkByOffset(fbnetwork, destination.getX() - current.getX(), destination.getY() - current.getY());
    }

    public static void moveFBNetworkByOffset(List<FBNetworkElement> fbNetwork, Position offset) {
        FBNetworkHelper.moveFBNetworkByOffset(fbNetwork, offset.getX(), offset.getY());
    }

    public static boolean targetSubappIsInSameFbNetwork(List<FBNetworkElement> elements, SubApp targetSubApp) {
        for (FBNetworkElement block : elements) {
            if (block.getFbNetwork().getNetworkElements().contains((Object)targetSubApp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTypeInsertionSafe(FBType type, EObject element) {
        if (type == null || element == null) {
            return true;
        }
        FBType editorType = FBNetworkHelper.getRootType(element);
        if (editorType != null) {
            if (type.getTypeEntry().equals(editorType.getTypeEntry())) {
                ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.Error_SelfInsertion, editorType.getName()));
                return false;
            }
            if (editorType instanceof CompositeFBType && !(editorType instanceof SubAppType) && type instanceof SubAppType) {
                ErrorMessenger.popUpErrorMessage((String)Messages.Error_TSAinCFB);
                return false;
            }
            if (FBNetworkHelper.containsType(editorType, FBNetworkHelper.getChildFBNElements(type))) {
                ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.Error_RecursiveType, type.getName(), editorType.getName()));
                return false;
            }
        }
        return true;
    }

    public static void selectElements(List<FBNetworkElement> elements) {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        GraphicalViewer viewer = (GraphicalViewer)part.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            List<EditPart> eps = elements.stream().map(arg_0 -> ((GraphicalViewer)viewer).getEditPartForModel(arg_0)).filter(Objects::nonNull).toList();
            if (eps != null) {
                viewer.setSelection((ISelection)new StructuredSelection(eps));
            }
        }
    }

    private static EList<? extends FBNetworkElement> getChildFBNElements(FBNetworkElement networkElem) {
        if (networkElem instanceof SubApp) {
            SubApp subapp = (SubApp)networkElem;
            if (subapp.isTyped()) {
                return subapp.getType().getFBNetwork().getNetworkElements();
            }
            return subapp.getSubAppNetwork().getNetworkElements();
        }
        FBType type = networkElem.getType();
        if (type != null) {
            return FBNetworkHelper.getChildFBNElements(type);
        }
        return new BasicEList();
    }

    private static EList<? extends FBNetworkElement> getChildFBNElements(FBType type) {
        if (!(type.getTypeEntry() instanceof ErrorTypeEntry)) {
            if (type instanceof BaseFBType) {
                BaseFBType baseFBType = (BaseFBType)type;
                return baseFBType.getInternalFbs();
            }
            if (type instanceof CompositeFBType) {
                CompositeFBType cFBType = (CompositeFBType)type;
                return cFBType.getFBNetwork().getNetworkElements();
            }
        }
        return new BasicEList();
    }

    public static FBType getRootType(EObject element) {
        EObject root = EcoreUtil.getRootContainer((EObject)element);
        if (root instanceof FBType) {
            FBType fbType = (FBType)root;
            return fbType;
        }
        return null;
    }

    private static boolean containsType(FBType editorType, EList<? extends FBNetworkElement> networkElementList) {
        for (FBNetworkElement elem : networkElementList) {
            if (!editorType.getTypeEntry().equals(elem.getTypeEntry()) && !FBNetworkHelper.containsType(editorType, FBNetworkHelper.getChildFBNElements(elem))) continue;
            return true;
        }
        return false;
    }

    private FBNetworkHelper() {
        throw new IllegalStateException("FBNetworkHelper is a utility class that can not be instantiated");
    }

    public static void loadSubappNetwork(FBNetworkElement network) {
        if (network instanceof SubApp) {
            SubApp subApp = (SubApp)network;
            subApp.loadSubAppNetwork();
            FBNetworkHelper.parseSubNetworks(subApp.getSubAppNetwork().getNetworkElements());
        } else if (network instanceof CFBInstance) {
            CFBInstance cFB = (CFBInstance)network;
            cFB.loadCFBNetwork();
            FBNetworkHelper.parseSubNetworks(cFB.getCfbNetwork().getNetworkElements());
        }
    }

    private static void parseSubNetworks(List<FBNetworkElement> networkElements) {
        for (FBNetworkElement fbe : networkElements) {
            if (!FBNetworkHelper.hasNetwork(fbe)) continue;
            FBNetworkHelper.loadSubappNetwork(fbe);
        }
    }

    private static boolean hasNetwork(FBNetworkElement networkElement) {
        return networkElement instanceof SubApp || networkElement instanceof CFBInstance;
    }

    public static String getFullHierarchicalName(FBNetworkElement fbNetworkElement) {
        ArrayDeque<String> names = new ArrayDeque<String>();
        if (fbNetworkElement != null) {
            names.addFirst(fbNetworkElement.getName());
            FBNetworkElement container = fbNetworkElement;
            do {
                FBNetworkElement runner;
                if (FBNetworkHelper.isMappedCommunicationFb(runner = container)) {
                    names.addFirst(".");
                    names.addFirst(MappingAnnotations.getHierarchicalName(runner));
                    break;
                }
                FBNetwork network = runner.getFbNetwork();
                container = network != null ? network.eContainer() : runner.eContainer();
                if (!(container instanceof INamedElement)) break;
                if (container instanceof MappingTarget) {
                    MappingTarget mappingtarget = (MappingTarget)((Object)container);
                    names.addFirst(".");
                    names.addFirst(MappingAnnotations.getHierarchicalName(mappingtarget));
                    break;
                }
                names.addFirst(".");
                names.addFirst(((INamedElement)container).getName());
            } while (container instanceof FBNetworkElement);
            StringBuilder fullName = new StringBuilder();
            for (String string : names) {
                fullName.append(string);
            }
            return fullName.toString();
        }
        return null;
    }

    protected static boolean isMappedCommunicationFb(FBNetworkElement runner) {
        return runner instanceof CommunicationChannel && runner.getFbNetwork() == null;
    }

    public static EObject getModelFromHierarchicalName(String fullHierarchicalName, AutomationSystem system) {
        String[] path = fullHierarchicalName.split("\\.");
        INamedElement retVal = system.getApplicationNamed(path[0]);
        if (retVal != null) {
            if (path.length > 1) {
                retVal = FBNetworkHelper.parseSubappPath(retVal.getFBNetwork(), Arrays.copyOfRange(path, 1, path.length));
            }
        } else if (path.length > 2 && (retVal = system.getDeviceNamed(path[0])) != null && (retVal = ((Device)retVal).getResourceNamed(path[1])) != null && path.length > 2) {
            retVal = FBNetworkHelper.parseSubappPath(((Resource)retVal).getFBNetwork(), Arrays.copyOfRange(path, 2, path.length));
        }
        return retVal;
    }

    private static EObject parseSubappPath(FBNetwork network, String[] path) {
        FBNetworkElement retVal = null;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            retVal = network.getElementNamed(element);
            if (retVal instanceof SubApp) {
                SubApp subApp = (SubApp)retVal;
                network = subApp.loadSubAppNetwork();
            } else if (retVal instanceof CFBInstance) {
                CFBInstance cFB = (CFBInstance)retVal;
                network = cFB.loadCFBNetwork();
            } else {
                return null;
            }
            if (network == null) {
                return null;
            }
            ++n2;
        }
        return retVal;
    }

    private static class FBNetworkAdapterLessCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;

        private FBNetworkAdapterLessCopier() {
        }

        public EObject copy(EObject eObject) {
            if (!(eObject instanceof AdapterFB)) {
                return super.copy(eObject);
            }
            return null;
        }
    }
}

