/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class EUInformation
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=887");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=888");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=889");
    private final String namespaceUri;
    private final Integer unitId;
    private final LocalizedText displayName;
    private final LocalizedText description;

    public EUInformation(String namespaceUri, Integer unitId, LocalizedText displayName, LocalizedText description) {
        this.namespaceUri = namespaceUri;
        this.unitId = unitId;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public Integer getUnitId() {
        return this.unitId;
    }

    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    protected EUInformation(EUInformationBuilder<?, ?> b) {
        super(b);
        this.namespaceUri = ((EUInformationBuilder)b).namespaceUri;
        this.unitId = ((EUInformationBuilder)b).unitId;
        this.displayName = ((EUInformationBuilder)b).displayName;
        this.description = ((EUInformationBuilder)b).description;
    }

    public static EUInformationBuilder<?, ?> builder() {
        return new EUInformationBuilderImpl();
    }

    public EUInformationBuilder<?, ?> toBuilder() {
        return new EUInformationBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EUInformation)) {
            return false;
        }
        EUInformation other = (EUInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$unitId = this.getUnitId();
        Integer other$unitId = other.getUnitId();
        if (this$unitId == null ? other$unitId != null : !((Object)this$unitId).equals(other$unitId)) {
            return false;
        }
        String this$namespaceUri = this.getNamespaceUri();
        String other$namespaceUri = other.getNamespaceUri();
        if (this$namespaceUri == null ? other$namespaceUri != null : !this$namespaceUri.equals(other$namespaceUri)) {
            return false;
        }
        LocalizedText this$displayName = this.getDisplayName();
        LocalizedText other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !((Object)this$displayName).equals(other$displayName)) {
            return false;
        }
        LocalizedText this$description = this.getDescription();
        LocalizedText other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !((Object)this$description).equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EUInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $unitId = this.getUnitId();
        result = result * 59 + ($unitId == null ? 43 : ((Object)$unitId).hashCode());
        String $namespaceUri = this.getNamespaceUri();
        result = result * 59 + ($namespaceUri == null ? 43 : $namespaceUri.hashCode());
        LocalizedText $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : ((Object)$displayName).hashCode());
        LocalizedText $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EUInformation(namespaceUri=" + this.getNamespaceUri() + ", unitId=" + this.getUnitId() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    private static final class EUInformationBuilderImpl
    extends EUInformationBuilder<EUInformation, EUInformationBuilderImpl> {
        private EUInformationBuilderImpl() {
        }

        @Override
        protected EUInformationBuilderImpl self() {
            return this;
        }

        @Override
        public EUInformation build() {
            return new EUInformation(this);
        }
    }

    public static abstract class EUInformationBuilder<C extends EUInformation, B extends EUInformationBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String namespaceUri;
        private Integer unitId;
        private LocalizedText displayName;
        private LocalizedText description;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EUInformationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EUInformation instance, EUInformationBuilder<?, ?> b) {
            b.namespaceUri(instance.namespaceUri);
            b.unitId(instance.unitId);
            b.displayName(instance.displayName);
            b.description(instance.description);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return (B)this.self();
        }

        public B unitId(Integer unitId) {
            this.unitId = unitId;
            return (B)this.self();
        }

        public B displayName(LocalizedText displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        public B description(LocalizedText description) {
            this.description = description;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EUInformation.EUInformationBuilder(super=" + super.toString() + ", namespaceUri=" + this.namespaceUri + ", unitId=" + this.unitId + ", displayName=" + this.displayName + ", description=" + this.description + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EUInformation> {
        @Override
        public Class<EUInformation> getType() {
            return EUInformation.class;
        }

        @Override
        public EUInformation decode(SerializationContext context, UaDecoder decoder) {
            String namespaceUri = decoder.readString("NamespaceUri");
            Integer unitId = decoder.readInt32("UnitId");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            return new EUInformation(namespaceUri, unitId, displayName, description);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EUInformation value) {
            encoder.writeString("NamespaceUri", value.getNamespaceUri());
            encoder.writeInt32("UnitId", value.getUnitId());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
        }
    }
}

