/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.stcore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum STCommentPosition implements Enumerator
{
    UNKNOWN(0, "UNKNOWN", "UNKNOWN"),
    BEFORE(1, "BEFORE", "BEFORE"),
    AFTER(2, "AFTER", "AFTER"),
    INNER(3, "INNER", "INNER");

    public static final int UNKNOWN_VALUE = 0;
    public static final int BEFORE_VALUE = 1;
    public static final int AFTER_VALUE = 2;
    public static final int INNER_VALUE = 3;
    private static final STCommentPosition[] VALUES_ARRAY;
    public static final List<STCommentPosition> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new STCommentPosition[]{UNKNOWN, BEFORE, AFTER, INNER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static STCommentPosition get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            STCommentPosition result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static STCommentPosition getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            STCommentPosition result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static STCommentPosition get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return BEFORE;
            }
            case 2: {
                return AFTER;
            }
            case 3: {
                return INNER;
            }
        }
        return null;
    }

    private STCommentPosition(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

