/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.plugin;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.fordiac.ide.model.search.ISearchFactory;
import org.eclipse.fordiac.ide.model.search.Messages;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class SearchFactoryRegistryReader {
    private static final String FACTORY_ID = "factory";
    private static final String ATT_CLASS = "class";
    private static final String ATT_TYPE = "type";
    private static final String CHILD_SOURCE = "source";

    public static void readRegistry() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.fordiac.ide.model.search", FACTORY_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IConfigurationElement[] sources;
                ISearchFactory factory;
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    factory = (ISearchFactory)element.createExecutableExtension(ATT_CLASS);
                }
                catch (Exception e) {
                    SearchFactoryRegistryReader.log(element, Messages.SearchFactoryRegistryReader_CannotCreateInstance, e);
                    break block7;
                }
                IConfigurationElement[] iConfigurationElementArray2 = sources = element.getChildren(CHILD_SOURCE);
                int n3 = sources.length;
                int n4 = 0;
                while (n4 < n3) {
                    block8: {
                        Class sourceClass;
                        IConfigurationElement source = iConfigurationElementArray2[n4];
                        String type = source.getAttribute(ATT_TYPE);
                        try {
                            sourceClass = CommonPlugin.loadClass((String)source.getDeclaringExtension().getContributor().getName(), (String)type);
                        }
                        catch (ClassNotFoundException e) {
                            SearchFactoryRegistryReader.log(source, Messages.SearchFactoryRegistryReader_SourceInvalidClass, e);
                            break block8;
                        }
                        ISearchFactory previousFactory = ISearchFactory.Registry.INSTANCE.registerFactory(sourceClass, factory);
                        if (previousFactory != null) {
                            SearchFactoryRegistryReader.log(source, MessageFormat.format(Messages.SearchFactoryRegistryReader_AlreadyRegistered, previousFactory.getClass().getName(), sourceClass.getName()));
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static void log(IConfigurationElement element, String message) {
        FordiacLogHelper.logError((String)MessageFormat.format(Messages.SearchFactoryRegistryReader_LogMessage, message, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getDeclaringExtension().getContributor().getName()));
    }

    private static void log(IConfigurationElement element, String message, Throwable t) {
        FordiacLogHelper.logError((String)MessageFormat.format(Messages.SearchFactoryRegistryReader_LogMessage, message, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getDeclaringExtension().getContributor().getName()), (Throwable)t);
    }

    private SearchFactoryRegistryReader() {
        throw new UnsupportedOperationException();
    }
}

