/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.ui.provider.ExtendedColorRegistry;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class AdapterFactoryLabelProvider
implements ILabelProvider,
ITableLabelProvider,
INotifyChangedListener {
    protected AdapterFactory adapterFactory;
    protected Font defaultFont;
    protected Color defaultForeground;
    protected Color defaultBackground;
    protected Collection<ILabelProviderListener> labelProviderListeners;
    protected boolean isFireLabelUpdateNotifications;
    private static final Class<?> IItemLabelProviderClass = IItemLabelProvider.class;
    private static final Class<?> ITableItemLabelProviderClass = ITableItemLabelProvider.class;
    private static final Class<?> IItemFontProviderClass = IItemFontProvider.class;
    private static final Class<?> IItemColorProviderClass = IItemColorProvider.class;
    private static final Class<?> ITableItemFontProviderClass = ITableItemFontProvider.class;
    private static final Class<?> ITableItemColorProviderClass = ITableItemColorProvider.class;
    private static final Class<?> IItemStyledLabelProviderClass = IItemStyledLabelProvider.class;

    public AdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.labelProviderListeners = new ArrayList<ILabelProviderListener>();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.adapterFactory = adapterFactory;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
    }

    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    public void setDefaultForeground(Color color) {
        this.defaultForeground = color;
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public void setDefaultBackground(Color color) {
        this.defaultBackground = color;
    }

    public void addListener(ILabelProviderListener listener) {
        if (!this.labelProviderListeners.contains(listener)) {
            this.labelProviderListeners.add(listener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        this.labelProviderListeners.remove(listener);
    }

    public void dispose() {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
    }

    public boolean isLabelProperty(Object object, String id) {
        return true;
    }

    public Image getImage(Object object) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProviderClass);
        return itemLabelProvider != null ? this.getImageFromObject(itemLabelProvider.getImage(object)) : this.getDefaultImage(object);
    }

    protected Image getDefaultImage(Object object) {
        String image = "full/obj16/GenericValue";
        if (object instanceof String) {
            image = "full/obj16/TextValue";
        } else if (object instanceof Boolean) {
            image = "full/obj16/BooleanValue";
        } else if (object instanceof Float || object instanceof Double) {
            image = "full/obj16/RealValue";
        } else if (object instanceof Integer || object instanceof Short || object instanceof Long || object instanceof Byte) {
            image = "full/obj16/RealValue";
        }
        return this.getImageFromObject(EMFEditPlugin.INSTANCE.getImage(image));
    }

    protected Image getImageFromObject(Object object) {
        return ExtendedImageRegistry.INSTANCE.getImage(object);
    }

    public String getText(Object object) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProviderClass);
        return itemLabelProvider != null ? itemLabelProvider.getText(object) : (object == null ? "" : object.toString());
    }

    public Font getFont(Object object) {
        IItemFontProvider itemFontProvider = (IItemFontProvider)this.adapterFactory.adapt(object, IItemFontProviderClass);
        return itemFontProvider != null ? this.getFontFromObject(itemFontProvider.getFont(object)) : null;
    }

    protected Font getFontFromObject(Object object) {
        return object == null ? null : ExtendedFontRegistry.INSTANCE.getFont(this.defaultFont, object);
    }

    public org.eclipse.jface.viewers.StyledString getStyledText(Object object) {
        IItemStyledLabelProvider itemStyledLabelProvider = (IItemStyledLabelProvider)this.adapterFactory.adapt(object, IItemStyledLabelProviderClass);
        return itemStyledLabelProvider != null ? this.getStyledStringFromObject(itemStyledLabelProvider.getStyledText(object)) : AdapterFactoryLabelProvider.createStyledString(this.getText(object));
    }

    static org.eclipse.jface.viewers.StyledString createStyledString(String text) {
        return text == null ? new org.eclipse.jface.viewers.StyledString() : new org.eclipse.jface.viewers.StyledString(text);
    }

    protected org.eclipse.jface.viewers.StyledString getStyledStringFromObject(Object object) {
        if (object == null) {
            return new org.eclipse.jface.viewers.StyledString();
        }
        if (object instanceof org.eclipse.jface.viewers.StyledString) {
            return (org.eclipse.jface.viewers.StyledString)object;
        }
        if (object instanceof String) {
            return new org.eclipse.jface.viewers.StyledString((String)object);
        }
        if (object instanceof StyledString) {
            return this.toJFaceStyledString((StyledString)object);
        }
        return new org.eclipse.jface.viewers.StyledString(object.toString());
    }

    protected org.eclipse.jface.viewers.StyledString toJFaceStyledString(StyledString styledString) {
        org.eclipse.jface.viewers.StyledString result = new org.eclipse.jface.viewers.StyledString();
        for (StyledString.Fragment fragment : styledString) {
            StyledString.Style style = fragment.getStyle();
            String string = fragment.getString();
            if (string == null) {
                result.append("");
                continue;
            }
            if (style == StyledString.Style.NO_STYLE) {
                result.append(string);
                continue;
            }
            if (style == StyledString.Style.COUNTER_STYLER) {
                result.append(string, org.eclipse.jface.viewers.StyledString.COUNTER_STYLER);
                continue;
            }
            if (style == StyledString.Style.DECORATIONS_STYLER) {
                result.append(string, org.eclipse.jface.viewers.StyledString.DECORATIONS_STYLER);
                continue;
            }
            if (style == StyledString.Style.QUALIFIER_STYLER) {
                result.append(string, org.eclipse.jface.viewers.StyledString.QUALIFIER_STYLER);
                continue;
            }
            StyledString.Styler styler = this.createStyler(style);
            result.append(string, styler);
        }
        return result;
    }

    protected StyledString.Styler createStyler(StyledString.Style style) {
        return new ConvertingStyler(style);
    }

    public Color getForeground(Object object) {
        IItemColorProvider itemColorProvider = (IItemColorProvider)this.adapterFactory.adapt(object, IItemColorProviderClass);
        return itemColorProvider != null ? this.getColorFromObject(itemColorProvider.getForeground(object)) : null;
    }

    public Color getBackground(Object object) {
        IItemColorProvider itemColorProvider = (IItemColorProvider)this.adapterFactory.adapt(object, IItemColorProviderClass);
        return itemColorProvider != null ? this.getColorFromObject(itemColorProvider.getBackground(object)) : null;
    }

    protected Color getColorFromObject(Object object) {
        return object == null ? null : ExtendedColorRegistry.INSTANCE.getColor(this.defaultForeground, this.defaultBackground, object);
    }

    public Image getColumnImage(Object object, int columnIndex) {
        ITableItemLabelProvider tableItemLabelProvider = (ITableItemLabelProvider)this.adapterFactory.adapt(object, ITableItemLabelProviderClass);
        Image result = null;
        if (tableItemLabelProvider != null) {
            result = this.getImageFromObject(tableItemLabelProvider.getColumnImage(object, columnIndex));
        } else {
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProviderClass);
            if (itemLabelProvider != null) {
                result = this.getImageFromObject(itemLabelProvider.getImage(object));
            }
        }
        return result;
    }

    public String getColumnText(Object object, int columnIndex) {
        ITableItemLabelProvider tableItemLabelProvider = (ITableItemLabelProvider)this.adapterFactory.adapt(object, ITableItemLabelProviderClass);
        if (tableItemLabelProvider != null) {
            return tableItemLabelProvider.getColumnText(object, columnIndex);
        }
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProviderClass);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText(object);
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public Font getFont(Object object, int columnIndex) {
        ITableItemFontProvider tableItemFontProvider = (ITableItemFontProvider)this.adapterFactory.adapt(object, ITableItemFontProviderClass);
        Font result = null;
        if (tableItemFontProvider != null) {
            result = this.getFontFromObject(tableItemFontProvider.getFont(object, columnIndex));
        } else {
            IItemFontProvider itemFontProvider = (IItemFontProvider)this.adapterFactory.adapt(object, IItemFontProviderClass);
            if (itemFontProvider != null) {
                result = this.getFontFromObject(itemFontProvider.getFont(object));
            }
        }
        return result;
    }

    public Color getForeground(Object object, int columnIndex) {
        ITableItemColorProvider tableItemColorProvider = (ITableItemColorProvider)this.adapterFactory.adapt(object, ITableItemColorProviderClass);
        Color result = null;
        if (tableItemColorProvider != null) {
            result = this.getColorFromObject(tableItemColorProvider.getForeground(object, columnIndex));
        } else {
            IItemColorProvider itemColorProvider = (IItemColorProvider)this.adapterFactory.adapt(object, IItemColorProviderClass);
            if (itemColorProvider != null) {
                result = this.getColorFromObject(itemColorProvider.getForeground(object));
            }
        }
        return result;
    }

    public Color getBackground(Object object, int columnIndex) {
        ITableItemColorProvider tableItemColorProvider = (ITableItemColorProvider)this.adapterFactory.adapt(object, ITableItemColorProviderClass);
        Color result = null;
        if (tableItemColorProvider != null) {
            result = this.getColorFromObject(tableItemColorProvider.getBackground(object, columnIndex));
        } else {
            IItemColorProvider itemColorProvider = (IItemColorProvider)this.adapterFactory.adapt(object, IItemColorProviderClass);
            if (itemColorProvider != null) {
                result = this.getColorFromObject(itemColorProvider.getBackground(object));
            }
        }
        return result;
    }

    public boolean isFireLabelUpdateNotifications() {
        return this.isFireLabelUpdateNotifications;
    }

    public void setFireLabelUpdateNotifications(boolean isFireLabelUpdateNotifications) {
        this.isFireLabelUpdateNotifications = isFireLabelUpdateNotifications;
    }

    public void fireLabelProviderChanged() {
        for (ILabelProviderListener labelProviderListener : this.labelProviderListeners) {
            labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void notifyChanged(Notification notification) {
        if (this.isFireLabelUpdateNotifications() && (!(notification instanceof IViewerNotification) || ((IViewerNotification)notification).isLabelUpdate())) {
            for (ILabelProviderListener labelProviderListener : this.labelProviderListeners) {
                labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, notification.getNotifier()));
            }
        }
    }

    public static class ColorProvider
    extends AdapterFactoryLabelProvider
    implements IColorProvider,
    ITableColorProvider {
        public ColorProvider(AdapterFactory adapterFactory, Color defaultForeground, Color defaultBackground) {
            super(adapterFactory);
            this.setDefaultForeground(defaultForeground);
            this.setDefaultBackground(defaultBackground);
        }

        public ColorProvider(AdapterFactory adapterFactory, Viewer viewer) {
            this(adapterFactory, viewer.getControl().getForeground(), viewer.getControl().getBackground());
        }
    }

    protected class ConvertingStyler
    extends StyledString.Styler {
        protected final StyledString.Style style;

        protected ConvertingStyler(StyledString.Style style) {
            this.style = style;
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = AdapterFactoryLabelProvider.this.getFontFromObject(this.style.getFont());
            textStyle.background = AdapterFactoryLabelProvider.this.getColorFromObject(this.style.getBackgoundColor());
            textStyle.foreground = AdapterFactoryLabelProvider.this.getColorFromObject(this.style.getForegroundColor());
            textStyle.strikeout = this.style.isStrikedout();
            textStyle.strikeoutColor = AdapterFactoryLabelProvider.this.getColorFromObject(this.style.getStrikeoutColor());
            textStyle.borderColor = AdapterFactoryLabelProvider.this.getColorFromObject(this.style.getBorderColor());
            switch (this.style.getBorderStyle()) {
                case NONE: {
                    textStyle.borderStyle = 0;
                    break;
                }
                case SOLID: {
                    textStyle.borderStyle = 1;
                    break;
                }
                case DOT: {
                    textStyle.borderStyle = 4;
                    break;
                }
                case DASH: {
                    textStyle.borderStyle = 2;
                }
            }
            switch (this.style.getUnderlineStyle()) {
                case NONE: {
                    textStyle.underline = false;
                    break;
                }
                case SINGLE: {
                    textStyle.underline = true;
                    textStyle.underlineStyle = 0;
                    textStyle.underlineColor = AdapterFactoryLabelProvider.this.getColorFromObject(this.style.getUnderlineColor());
                    break;
                }
                case DOUBLE: {
                    textStyle.underline = true;
                    textStyle.underlineStyle = 1;
                    textStyle.underlineColor = AdapterFactoryLabelProvider.this.getColorFromObject(this.style.getUnderlineColor());
                    break;
                }
                case ERROR: {
                    textStyle.underline = true;
                    textStyle.underlineStyle = 2;
                    textStyle.underlineColor = AdapterFactoryLabelProvider.this.getColorFromObject(this.style.getUnderlineColor());
                    break;
                }
                case LINK: {
                    textStyle.underline = true;
                    textStyle.underlineStyle = 4;
                    textStyle.underlineColor = AdapterFactoryLabelProvider.this.getColorFromObject(this.style.getUnderlineColor());
                    break;
                }
                case SQUIGGLE: {
                    textStyle.underline = true;
                    textStyle.underlineStyle = 3;
                    textStyle.underlineColor = AdapterFactoryLabelProvider.this.getColorFromObject(this.style.getUnderlineColor());
                }
            }
        }
    }

    public static class FontAndColorProvider
    extends AdapterFactoryLabelProvider
    implements IColorProvider,
    IFontProvider,
    ITableColorProvider,
    ITableFontProvider {
        public FontAndColorProvider(AdapterFactory adapterFactory, Font defaultFont, Color defaultForeground, Color defaultBackground) {
            super(adapterFactory);
            this.setDefaultFont(defaultFont);
            this.setDefaultForeground(defaultForeground);
            this.setDefaultBackground(defaultBackground);
        }

        public FontAndColorProvider(AdapterFactory adapterFactory, Viewer viewer) {
            this(adapterFactory, viewer.getControl().getFont(), viewer.getControl().getForeground(), viewer.getControl().getBackground());
        }
    }

    public static class FontProvider
    extends AdapterFactoryLabelProvider
    implements IFontProvider,
    ITableFontProvider {
        public FontProvider(AdapterFactory adapterFactory, Font defaultFont) {
            super(adapterFactory);
            this.setDefaultFont(defaultFont);
        }

        public FontProvider(AdapterFactory adapterFactory, Viewer viewer) {
            this(adapterFactory, viewer.getControl().getFont());
        }
    }

    public static class StyledLabelProvider
    extends AdapterFactoryLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IColorProvider,
    IFontProvider,
    ITableColorProvider,
    ITableFontProvider {
        public StyledLabelProvider(AdapterFactory adapterFactory, Font defaultFont, Color defaultForeground, Color defaultBackground) {
            super(adapterFactory);
            this.setDefaultFont(defaultFont);
            this.setDefaultForeground(defaultForeground);
            this.setDefaultBackground(defaultBackground);
        }

        public StyledLabelProvider(AdapterFactory adapterFactory, Viewer viewer) {
            this(adapterFactory, viewer.getControl().getFont(), viewer.getControl().getForeground(), viewer.getControl().getBackground());
        }
    }
}

