/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk.commands;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.elk.FordiacLayoutData;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.gef.commands.Command;

public class BlockLayoutCommand
extends Command {
    private final FordiacLayoutData data;
    private final Map<FBNetworkElement, Position> oldPositions = new HashMap<FBNetworkElement, Position>();
    private final Map<Group, Map.Entry<Double, Double>> oldGroupSizes = new HashMap<Group, Map.Entry<Double, Double>>();

    public BlockLayoutCommand(FordiacLayoutData data) {
        this.data = data;
    }

    public void execute() {
        this.saveDataForUndo();
        this.updateModelElements();
    }

    public void redo() {
        this.updateModelElements();
    }

    public void undo() {
        this.oldPositions.forEach(PositionableElement::setPosition);
        this.oldGroupSizes.forEach(BlockLayoutCommand::setGroupSize);
    }

    private void saveDataForUndo() {
        this.data.getPositions().keySet().forEach(elem -> {
            Position position = this.oldPositions.put((FBNetworkElement)elem, (Position)EcoreUtil.copy((EObject)elem.getPosition()));
        });
        this.data.getGroups().keySet().forEach(group -> {
            AbstractMap.SimpleEntry<Double, Double> simpleEntry = this.oldGroupSizes.put((Group)group, (Map.Entry<Double, Double>)new AbstractMap.SimpleEntry<Double, Double>(group.getHeight(), group.getWidth()));
        });
    }

    private void updateModelElements() {
        for (Map.Entry<FBNetworkElement, Position> entry : this.data.getPositions().entrySet()) {
            Position pos = entry.getValue();
            entry.getKey().updatePositionFromScreenCoordinates((int)pos.getX(), (int)pos.getY());
        }
        this.data.getGroups().forEach(BlockLayoutCommand::setGroupSize);
    }

    private static void setGroupSize(Group group, Map.Entry<Double, Double> size) {
        group.setHeight((double)size.getKey().intValue());
        group.setWidth((double)size.getValue().intValue());
    }
}

