/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.properties;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.EventContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.EventLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.properties.AdapterInterfaceElementSection;
import org.eclipse.fordiac.ide.fbtypeeditor.properties.DeSelectAllWidget;
import org.eclipse.fordiac.ide.gef.widgets.PinInfoBasicWidget;
import org.eclipse.fordiac.ide.gef.widgets.PinInfoDataWidget;
import org.eclipse.fordiac.ide.model.commands.create.WithCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.model.ui.nat.DataTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.DataTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DataInterfaceElementSection
extends AdapterInterfaceElementSection {
    private TableViewer withEventsViewer;
    private Group eventComposite;
    private DeSelectAllWidget deSelectAllWidget;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createEventSection(this.getRightComposite());
    }

    @Override
    protected PinInfoBasicWidget createPinInfoSection(Composite parent) {
        return new PinInfoDataWidget(parent, this.getWidgetFactory());
    }

    private void createEventSection(Composite parent) {
        this.eventComposite = this.getWidgetFactory().createGroup(parent, FordiacMessages.With);
        this.eventComposite.setLayout((Layout)new GridLayout(2, false));
        this.eventComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.deSelectAllWidget = new DeSelectAllWidget();
        this.deSelectAllWidget.createControls((Composite)this.eventComposite, (FormToolkit)this.getWidgetFactory());
        this.withEventsViewer = TableWidgetFactory.createPropertyTableViewer((Composite)this.eventComposite, (int)32);
        this.withEventsViewer.setContentProvider((IContentProvider)new EventContentProvider());
        this.withEventsViewer.setLabelProvider((IBaseLabelProvider)new EventLabelProvider());
        this.deSelectAllWidget.bindToTableViewer(this.withEventsViewer, this);
        Table tableWith = this.withEventsViewer.getTable();
        DataInterfaceElementSection.configureTableLayout(tableWith);
        tableWith.addListener(13, this.createListener());
    }

    private Listener createListener() {
        return event -> {
            if (event.detail == 32) {
                TableItem checkedItem = (TableItem)event.item;
                Event e = (Event)checkedItem.getData();
                With with = e.getWith().stream().filter(w -> w.getVariables().equals(this.getType())).findFirst().orElse(null);
                if (checkedItem.getChecked()) {
                    if (with == null) {
                        this.executeCommand((Command)new WithCreateCommand(e, this.getType()));
                    }
                    this.deSelectAllWidget.setSelection(Arrays.stream(((Table)event.widget).getItems()).allMatch(TableItem::getChecked));
                } else if (with != null) {
                    this.executeCommand((Command)new DeleteWithCommand(with));
                    this.deSelectAllWidget.setSelection(false);
                }
            }
        };
    }

    private static void configureTableLayout(Table tableWith) {
        TableColumn column1 = new TableColumn(tableWith, 16384);
        column1.setText(FordiacMessages.Event);
        TableColumn column2 = new TableColumn(tableWith, 16384);
        column2.setText(FordiacMessages.DataType);
        TableColumn column3 = new TableColumn(tableWith, 16384);
        column3.setText(FordiacMessages.Comment);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 100));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 100));
        tableWith.setLayout((Layout)layout);
    }

    public VarDeclaration getType() {
        return (VarDeclaration)super.getType();
    }

    @Override
    protected void performRefresh() {
        super.performRefresh();
        EObject container = this.getType().eContainer();
        if (container != null && !(container.eContainer() instanceof SubAppType)) {
            this.eventComposite.setVisible(true);
            this.withEventsViewer.setInput((Object)this.getType());
            this.withEventsViewer.getTable().setEnabled(this.isEditable());
            Arrays.stream(this.withEventsViewer.getTable().getItems()).forEach(item -> item.setChecked(false));
            this.getType().getWiths().stream().map(with -> this.withEventsViewer.testFindItem((Object)with.eContainer())).filter(TableItem.class::isInstance).forEach(item -> ((TableItem)item).setChecked(true));
            this.deSelectAllWidget.setSelection(Arrays.stream(this.withEventsViewer.getTable().getItems()).allMatch(TableItem::getChecked));
        } else {
            this.eventComposite.setVisible(false);
        }
    }

    @Override
    protected void setInputInit() {
        if (this.getType() != null) {
            if (this.getType().isInOutVar() && !this.getType().isIsInput()) {
                this.setupPinInfoWidget((IInterfaceElement)this.getType().getInOutVarOpposite());
            } else {
                this.setupPinInfoWidget((IInterfaceElement)this.getType());
            }
        }
        this.deSelectAllWidget.setEnabled(this.getCurrentCommandStack() != null);
        this.deSelectAllWidget.setCommandStack(this.getCurrentCommandStack());
    }

    @Override
    protected void setInputCode() {
        super.setInputCode();
        this.withEventsViewer.setInput(null);
        Arrays.stream(this.withEventsViewer.getTable().getItems()).forEach(item -> item.setGrayed(true));
    }

    @Override
    protected ITypeSelectionContentProvider getTypeSelectionContentProvider() {
        return DataTypeSelectionContentProvider.INSTANCE;
    }

    @Override
    protected ITreeContentProvider getTypeSelectionTreeContentProvider() {
        return DataTypeSelectionTreeContentProvider.INSTANCE;
    }
}

