/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.PlainMessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LibraryElementActivationListener
implements IPartListener,
IWindowListener {
    private final IEditorPart editorPart;
    private final IPartService partService;
    private boolean ignoreUpdates;

    public LibraryElementActivationListener(IEditorPart editorPart) {
        this.editorPart = editorPart;
        this.partService = editorPart.getSite().getWorkbenchWindow().getPartService();
        this.partService.addPartListener((IPartListener)this);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
    }

    public void dispose() {
        this.partService.removePartListener((IPartListener)this);
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
    }

    public void windowActivated(IWorkbenchWindow window) {
        window.getShell().getDisplay().asyncExec(() -> {
            IWorkbenchPage activePage = window.getActivePage();
            if (activePage != null) {
                this.handleActivation(activePage.getActivePart());
            }
        });
    }

    public void partActivated(IWorkbenchPart part) {
        this.handleActivation(part);
    }

    protected void handleActivation(IWorkbenchPart part) {
        if (part != this.editorPart || this.ignoreUpdates) {
            return;
        }
        try {
            this.ignoreUpdates = true;
            this.checkEditorActivated();
        }
        finally {
            this.ignoreUpdates = false;
        }
    }

    protected void checkEditorActivated() {
        if (!LibraryElementProvider.INSTANCE.isSynchronized(this.editorPart.getEditorInput())) {
            this.handleEditorInputChanged(this.editorPart.getEditorInput());
        }
    }

    protected void handleEditorInputChanged(IEditorInput editorInput) {
        PlainMessageDialog replaceContentDialog = PlainMessageDialog.getBuilder((Shell)this.editorPart.getSite().getShell(), (String)Messages.LibraryElementActivationListener_FileChangedTitle).message(MessageFormat.format(Messages.LibraryElementActivationListener_FileChangedMessage, editorInput.getToolTipText())).buttonLabels(List.of(Messages.LibraryElementActivationListener_ReplaceContentButton, Messages.LibraryElementActivationListener_IgnoreChangeButton)).build();
        if (replaceContentDialog.open() != 0) {
            return;
        }
        try {
            LibraryElementProvider.INSTANCE.synchronize(editorInput, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.editorPart.getSite().getShell(), (String)Messages.LibraryElementActivationListener_SyncErrorTitle, (String)MessageFormat.format(Messages.LibraryElementActivationListener_SyncErrorMessage, editorInput.getToolTipText()), (IStatus)e.getStatus());
        }
    }

    public IEditorPart getEditorPart() {
        return this.editorPart;
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

