/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.fordiac.ide.model.NamedElementComparator;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;

public final class ECCContentAndLabelProvider {
    public static final String EMPTY_FIELD = FordiacMessages.EmptyField;
    public static final String ONE_CONDITION = "1";

    public static List<Event> getOutputEvents(BasicFBType type) {
        ArrayList<Event> events = new ArrayList<Event>();
        if (type != null) {
            events.addAll((Collection<Event>)type.getInterfaceList().getEventOutputs());
            type.getInterfaceList().getSockets().stream().forEach(socket -> {
                boolean bl = events.addAll((Collection<Event>)socket.getAdapterFB().getInterface().getEventInputs());
            });
            type.getInterfaceList().getPlugs().stream().forEach(plug -> {
                boolean bl = events.addAll((Collection<Event>)plug.getAdapterFB().getInterface().getEventInputs());
            });
            Collections.sort(events, NamedElementComparator.INSTANCE);
        }
        return events;
    }

    public static boolean isOneConditionExpression(ECTransition transition) {
        return transition.getConditionExpression() != null && transition.getConditionExpression().equals(ONE_CONDITION);
    }

    public static List<String> getOutputEventNames(BasicFBType type) {
        ArrayList<String> eventNames = new ArrayList<String>(ECCContentAndLabelProvider.getEventNames(ECCContentAndLabelProvider.getOutputEvents(type)));
        eventNames.add(EMPTY_FIELD);
        return eventNames;
    }

    public static List<Event> getInputEvents(BasicFBType type) {
        ArrayList<Event> events = new ArrayList<Event>();
        if (type != null) {
            events.addAll((Collection<Event>)type.getInterfaceList().getEventInputs());
            type.getInterfaceList().getSockets().stream().forEach(socket -> {
                boolean bl = events.addAll((Collection<Event>)socket.getAdapterFB().getInterface().getEventOutputs());
            });
            type.getInterfaceList().getPlugs().stream().forEach(plug -> {
                boolean bl = events.addAll((Collection<Event>)plug.getAdapterFB().getInterface().getEventOutputs());
            });
            Collections.sort(events, NamedElementComparator.INSTANCE);
        }
        return events;
    }

    public static List<String> getInputEventNames(BasicFBType type) {
        ArrayList<String> inputEventNames = new ArrayList<String>(ECCContentAndLabelProvider.getEventNames(ECCContentAndLabelProvider.getInputEvents(type)));
        inputEventNames.add(EMPTY_FIELD);
        return inputEventNames;
    }

    public static List<String> getTransitionConditionEventNames(BasicFBType type) {
        ArrayList<String> transitionConditionEvents = new ArrayList<String>();
        transitionConditionEvents.add(ONE_CONDITION);
        transitionConditionEvents.addAll(ECCContentAndLabelProvider.getInputEventNames(type));
        return transitionConditionEvents;
    }

    public static List<Algorithm> getAlgorithms(BaseFBType type) {
        ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>((Collection<Algorithm>)type.getAlgorithm());
        Collections.sort(algorithms, NamedElementComparator.INSTANCE);
        return algorithms;
    }

    public static List<String> getAlgorithmNames(BasicFBType type) {
        ArrayList<String> algNames = new ArrayList<String>(ECCContentAndLabelProvider.getAlgorithms((BaseFBType)type).stream().map(INamedElement::getName).toList());
        algNames.add(EMPTY_FIELD);
        return algNames;
    }

    public static BasicFBType getFBType(ECAction action) {
        if (action.getECState() != null && action.getECState().getECC() != null) {
            return action.getECState().getECC().getBasicFBType();
        }
        return null;
    }

    public static List<ECState> getStates(BasicFBType type) {
        return type.getECC().getECState();
    }

    public static List<String> getStateNames(BasicFBType type) {
        return ECCContentAndLabelProvider.getStates(type).stream().map(INamedElement::getName).toList();
    }

    private static List<String> getEventNames(List<Event> eventList) {
        return eventList.stream().map(ECCContentAndLabelProvider::getEventName).toList();
    }

    public static String getEventName(Event event) {
        if (event.getBlockFBNetworkElement() instanceof AdapterFB) {
            return event.getBlockFBNetworkElement().getName() + "." + event.getName();
        }
        return event.getName();
    }

    private ECCContentAndLabelProvider() {
        throw new UnsupportedOperationException("ECActionHelpers should not be instantiated!");
    }
}

