/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry.ModelResolverDescriptor;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry.ModelResolverRegistry;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;

public class ModelResolverRegistryListener
extends AbstractRegistryEventListener {
    private static final String TAG_RESOLVER = "resolver";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_LABEL = "label";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_RANKING = "ranking";
    private final ModelResolverRegistry registry;

    public ModelResolverRegistryListener(String pluginID, String extensionPointID, ILog log, ModelResolverRegistry registry) {
        super(pluginID, extensionPointID, log);
        this.registry = registry;
    }

    protected boolean addedValid(IConfigurationElement element) {
        if (element.getName().equals(TAG_RESOLVER)) {
            String className = element.getAttribute(ATTRIBUTE_CLASS);
            String rankingStr = element.getAttribute(ATTRIBUTE_RANKING);
            int ranking = -1;
            try {
                ranking = Integer.parseInt(rankingStr);
            }
            catch (NumberFormatException e) {
                this.log(4, element, EMFCompareIDEUIMessages.getString("ModelResolverRegistry.invalidRanking", className, rankingStr));
            }
            String label = element.getAttribute(ATTRIBUTE_LABEL);
            String description = element.getAttribute(ATTRIBUTE_DESCRIPTION);
            ModelResolverDescriptor descriptor = new ModelResolverDescriptor(element, ATTRIBUTE_CLASS, ranking, label, description);
            this.registry.addResolver(className, descriptor);
            return true;
        }
        return false;
    }

    protected boolean removedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        this.registry.removeResolver(className);
        return true;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        return true;
    }
}

