/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import org.eclipse.draw2d.IFigure;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyler;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotation;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class UtilityMarkerAnnotationStyler
implements GraphicalAnnotationStyler {
    private static final String COLOR_PREDECESSOR = "org.eclipse.fordiac.ide.ui.PredecessorMarkerColor";
    private static final String COLOR_CONNECTION_SRC = "org.eclipse.fordiac.ide.ui.ConnectionSourceMarkerColor";
    public static final String TYPE_UTIL_PREDECESSOR = "org.eclipse.fordiac.ide.model.ui.annotation.util.predecessor";
    public static final String TYPE_UTIL_CONNECTION_SRC = "org.eclipse.fordiac.ide.model.ui.annotation.util.connectionSource";

    @Override
    public void applyStyles(IFigure figure, GraphicalAnnotation annotation) {
        Color annotationColor = this.getColor(annotation);
        if (annotationColor != null) {
            GraphicalAnnotationStyles.setAnnotationFeedbackBorder(figure, annotationColor);
        }
    }

    @Override
    public void removeStyles(IFigure figure, GraphicalAnnotation annotation) {
        GraphicalAnnotationStyles.removeAnnotationBorders(figure);
    }

    @Override
    public Color getColor(GraphicalAnnotation annotation) {
        return switch (annotation.getType()) {
            case TYPE_UTIL_PREDECESSOR -> UtilityMarkerAnnotationStyler.getPredecessorColor();
            case TYPE_UTIL_CONNECTION_SRC -> UtilityMarkerAnnotationStyler.getConnectionSourceColor();
            default -> null;
        };
    }

    @Override
    public Image getImage(GraphicalAnnotation annotation) {
        return null;
    }

    @Override
    public Image getOverlayImage(GraphicalAnnotation annotation) {
        return null;
    }

    private static Color getPredecessorColor() {
        return JFaceResources.getColorRegistry().get(COLOR_PREDECESSOR);
    }

    private static Color getConnectionSourceColor() {
        return JFaceResources.getColorRegistry().get(COLOR_CONNECTION_SRC);
    }
}

