/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.CommandRedoChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CommandUndoChange<T extends EObject>
extends AbstractCommandChange<T> {
    private final Command command;
    private final LibraryElement libraryElement;

    public CommandUndoChange(String name, URI elementURI, Class<T> elementClass, Command command, LibraryElement libraryElement) {
        super(name, elementURI, elementClass);
        this.command = Objects.requireNonNull(command);
        this.libraryElement = Objects.requireNonNull(libraryElement);
    }

    @Override
    public void initializeValidationData(T element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(T element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    @Override
    protected Command createCommand(T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Command performCommand(T element) {
        this.command.undo();
        return this.command;
    }

    @Override
    protected LibraryElement acquireLibraryElement(boolean editable) {
        return this.libraryElement;
    }

    @Override
    protected Change createUndoChange(Command command, LibraryElement libraryElement) {
        return new CommandRedoChange(this.getName(), this.getElementURI(), this.getElementClass(), command, libraryElement);
    }
}

