/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.delete;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ConfigurableModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.IFordiacPreviewChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteUpdateFBTypeInterfaceModelEdit
extends ConfigurableModelEdit<FBType> {
    final StructuredType struct;

    public DeleteUpdateFBTypeInterfaceModelEdit(FBType type, StructuredType struct) {
        super(MessageFormat.format(Messages.DeleteFBTypeParticipant_Change_DeleteFBTypeInterface, type.getName(), struct.getName()), EcoreUtil.getURI((EObject)type), FBType.class);
        this.struct = struct;
        this.setEnabled(false);
    }

    @Override
    public EnumSet<IFordiacPreviewChange.ChangeState> getAllowedChoices() {
        return EnumSet.of(IFordiacPreviewChange.ChangeState.CHANGE_TO_ANY, IFordiacPreviewChange.ChangeState.DELETE);
    }

    @Override
    public EnumSet<IFordiacPreviewChange.ChangeState> getDefaultSelection() {
        return EnumSet.of(IFordiacPreviewChange.ChangeState.CHANGE_TO_ANY);
    }

    @Override
    public void initializeValidationData(FBType element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(FBType element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        List<VarDeclaration> varDeclaration = this.getVarDeclarationsForStruct(element);
        if (varDeclaration.isEmpty()) {
            status.addError(this.struct.getQualifiedName() + " is not part of the interface of " + this.getName());
        }
        if (element.getTypeLibrary() == null || element.getTypeLibrary().getDataTypeLibrary() == null) {
            status.addError("Type Library is null");
        }
        return status;
    }

    @Override
    protected Command createCommand(FBType type) {
        List<VarDeclaration> varDeclarations = this.getVarDeclarationsForStruct(type);
        CompoundCommand cmd = new CompoundCommand();
        for (VarDeclaration varDec : varDeclarations) {
            if (this.getState().contains((Object)IFordiacPreviewChange.ChangeState.CHANGE_TO_ANY)) {
                cmd.add((Command)ChangeDataTypeCommand.forDataType((IInterfaceElement)varDec, (DataType)IecTypes.GenericTypes.ANY_STRUCT));
                continue;
            }
            if (!this.getState().contains((Object)IFordiacPreviewChange.ChangeState.DELETE)) continue;
            cmd.add((Command)new DeleteInterfaceCommand((IInterfaceElement)varDec));
        }
        return cmd;
    }

    private List<VarDeclaration> getVarDeclarationsForStruct(FBType element) {
        return element.getInterfaceList().getAllInterfaceElements().filter(VarDeclaration.class::isInstance).map(VarDeclaration.class::cast).filter(decl -> PackageNameHelper.getFullTypeName((LibraryElement)decl.getType()).equalsIgnoreCase(PackageNameHelper.getFullTypeName((LibraryElement)this.struct))).toList();
    }
}

