/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit.helper;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public final class InitialValueHelper {
    private InitialValueHelper() {
        throw new UnsupportedOperationException("Helper class InitialValueHelper should not be instantiated!");
    }

    public static String getInitialOrDefaultValue(Object element) {
        if (element instanceof VarDeclaration) {
            VarDeclaration varDec = (VarDeclaration)element;
            if (InitialValueHelper.hasInitalValue(element)) {
                return varDec.getValue().getValue();
            }
            String dtInitialValue = InitialValueHelper.getMemberVarValue(varDec);
            if (!dtInitialValue.isBlank()) {
                return dtInitialValue;
            }
            return InitialValueHelper.getDefaultValue(element);
        }
        if (element instanceof ErrorMarkerInterface) {
            ErrorMarkerInterface marker = (ErrorMarkerInterface)element;
            if (InitialValueHelper.hasInitalValue(element)) {
                return marker.getValue().getValue();
            }
        }
        if (element instanceof Attribute) {
            Attribute attr = (Attribute)element;
            if (InitialValueHelper.hasInitalValue(element)) {
                return attr.getValue();
            }
            return InitialValueHelper.getDefaultValue(element);
        }
        return "";
    }

    private static String getMemberVarValue(VarDeclaration v) {
        StructManipulator muxer;
        DataType dataType;
        if (v == null || v.getName() == null || v.getName().isBlank()) {
            return "";
        }
        BlockFBNetworkElement blockFBNetworkElement = v.getBlockFBNetworkElement();
        if (blockFBNetworkElement instanceof StructManipulator && (dataType = (muxer = (StructManipulator)blockFBNetworkElement).getDataType()) instanceof StructuredType) {
            StructuredType structType = (StructuredType)dataType;
            VarDeclaration matchingMember = structType.getMemberVariables().stream().filter(member -> v.getName().equals(member.getName())).findFirst().orElse(null);
            if (matchingMember != null && matchingMember.getValue() != null) {
                return matchingMember.getValue().getValue();
            }
        } else if (v.eContainer() instanceof VarDeclaration) {
            return InitialValueHelper.getMemberAccessDTInitialValue(v);
        }
        return "";
    }

    private static String getMemberAccessDTInitialValue(VarDeclaration v) {
        List namePath = v.getBlockRelativePath();
        VarDeclaration root = InitialValueHelper.getRootPin(v);
        try {
            Variable variable = VariableOperations.newVariable((VarDeclaration)root);
            for (String name : namePath.subList(1, namePath.size())) {
                variable = variable.getChildren().filter(child -> Objects.equals(child.getName(), name)).findFirst().orElseThrow();
            }
            return variable.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getValue(VarDeclaration varDecl) {
        return varDecl != null && varDecl.getValue() != null && varDecl.getValue().getValue() != null ? varDecl.getValue().getValue() : "";
    }

    private static VarDeclaration getRootPin(VarDeclaration v) {
        EObject eObject;
        VarDeclaration runner = v;
        while (runner != null && (eObject = runner.eContainer()) instanceof VarDeclaration) {
            VarDeclaration parent;
            runner = parent = (VarDeclaration)eObject;
        }
        return runner;
    }

    public static String getDefaultValue(Object element) {
        Attribute attr;
        VarDeclaration varDec;
        if (element instanceof VarDeclaration && (varDec = (VarDeclaration)element).getType() instanceof AnyType) {
            try {
                return VariableOperations.newVariable((VarDeclaration)varDec).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (element instanceof Attribute && (attr = (Attribute)element).getType() instanceof AnyType) {
            try {
                return VariableOperations.newVariable((Attribute)attr).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static Color getForegroundColor(Object element) {
        if ((element instanceof VarDeclaration || element instanceof Attribute) && !InitialValueHelper.hasInitalValue(element)) {
            return Display.getCurrent().getSystemColor(16);
        }
        return null;
    }

    public static boolean hasInitalValue(Object element) {
        if (element instanceof VarDeclaration) {
            VarDeclaration varDec = (VarDeclaration)element;
            return !InitialValueHelper.getValue(varDec).isEmpty();
        }
        if (element instanceof ErrorMarkerInterface) {
            ErrorMarkerInterface marker = (ErrorMarkerInterface)element;
            return marker.getValue() != null && marker.getValue().getValue() != null && !marker.getValue().getValue().isEmpty();
        }
        if (element instanceof Attribute) {
            Attribute attr = (Attribute)element;
            return attr.getValue() != null && !attr.getValue().equals("");
        }
        return false;
    }
}

