/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.widgets;

import java.util.Comparator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class TypeSelectionProposalProvider
implements IContentProposalProvider {
    private final Supplier<TypeLibrary> supplier;
    private final ITypeSelectionContentProvider contentProvider;
    private final Predicate<TypeEntry> additionalFilter;

    public TypeSelectionProposalProvider(Supplier<TypeLibrary> supplier, ITypeSelectionContentProvider contentProvider) {
        this(supplier, contentProvider, entry -> true);
    }

    public TypeSelectionProposalProvider(Supplier<TypeLibrary> supplier, ITypeSelectionContentProvider contentProvider, Predicate<TypeEntry> additionalFilter) {
        this.supplier = supplier;
        this.contentProvider = contentProvider;
        this.additionalFilter = additionalFilter;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        TypeLibrary typeLibrary = this.supplier.get();
        return (IContentProposal[])Stream.concat(this.contentProvider.getTypes(typeLibrary).filter(proposal -> TypeSelectionProposalProvider.matches(proposal.getName(), contents)).map(this::createProposal), this.contentProvider.getTypeEntries(typeLibrary).filter(this.additionalFilter).filter(proposal -> TypeSelectionProposalProvider.matches(proposal.getTypeName(), contents)).map(this::createProposal)).sorted(Comparator.comparing(IContentProposal::getLabel)).toArray(IContentProposal[]::new);
    }

    protected static boolean matches(String name, String contents) {
        return name.length() >= contents.length() && name.substring(0, contents.length()).equalsIgnoreCase(contents);
    }

    protected ContentProposal createProposal(LibraryElement libraryElement) {
        return new ContentProposal(PackageNameHelper.getFullTypeName((LibraryElement)libraryElement), libraryElement.getName(), PackageNameHelper.getFullTypeName((LibraryElement)libraryElement));
    }

    protected ContentProposal createProposal(TypeEntry typeEntry) {
        return new ContentProposal(typeEntry.getFullTypeName(), typeEntry.getTypeName(), typeEntry.getFullTypeName());
    }

    protected TypeLibrary getTypeLibrary() {
        return this.supplier.get();
    }

    protected ITypeSelectionContentProvider getContentProvider() {
        return this.contentProvider;
    }
}

