/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget.nattable;

import java.util.Objects;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.copy.command.PasteDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class PasteFromClipboardDataCommandHandler
extends AbstractLayerCommandHandler<PasteDataCommand> {
    private final SelectionLayer selectionLayer;
    private final IUniqueIndexLayer pasteLayer;

    public PasteFromClipboardDataCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, (IUniqueIndexLayer)selectionLayer);
    }

    public PasteFromClipboardDataCommandHandler(SelectionLayer selectionLayer, IUniqueIndexLayer pasteLayer) {
        this.selectionLayer = selectionLayer;
        this.pasteLayer = pasteLayer;
    }

    protected boolean doCommand(PasteDataCommand command) {
        String content = PasteFromClipboardDataCommandHandler.getClipboardContent();
        if (content.isEmpty()) {
            return true;
        }
        String[][] copiedCells = PasteFromClipboardDataCommandHandler.parseContent(content);
        PositionCoordinate anchor = this.selectionLayer.getSelectionAnchor();
        int pasteColumn = anchor.getColumnPosition();
        int pasteRow = anchor.getRowPosition();
        if (this.pasteLayer != this.selectionLayer) {
            pasteColumn = LayerUtil.convertColumnPosition((ILayer)this.selectionLayer, (int)pasteColumn, (IUniqueIndexLayer)this.pasteLayer);
            pasteRow = LayerUtil.convertRowPosition((ILayer)this.selectionLayer, (int)pasteRow, (IUniqueIndexLayer)this.pasteLayer);
        }
        String[][] stringArray = copiedCells;
        int n = copiedCells.length;
        int n2 = 0;
        while (n2 < n) {
            String[] copiedRow;
            String[] stringArray2 = copiedRow = stringArray[n2];
            int n3 = copiedRow.length;
            int n4 = 0;
            while (n4 < n3) {
                String copiedCell = stringArray2[n4];
                ILayerCell targetCell = this.pasteLayer.getCellByPosition(pasteColumn, pasteRow);
                if (EditUtils.isCellEditable((ILayerCell)targetCell, (IConfigRegistry)command.configRegistry)) {
                    this.pasteLayer.doCommand((ILayerCommand)new UpdateDataCommand((ILayer)this.pasteLayer, pasteColumn, pasteRow, (Object)copiedCell));
                }
                if (++pasteColumn >= this.pasteLayer.getColumnCount()) break;
                ++n4;
            }
            ++pasteRow;
            pasteColumn = anchor.getColumnPosition();
            ++n2;
        }
        return true;
    }

    protected static String getClipboardContent() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        try {
            String string = Objects.toString(clipboard.getContents((Transfer)TextTransfer.getInstance()), "");
            return string;
        }
        finally {
            clipboard.dispose();
        }
    }

    private static String[][] parseContent(String content) {
        return (String[][])content.lines().map(PasteFromClipboardDataCommandHandler::parseLine).toArray(n -> new String[n][]);
    }

    private static String[] parseLine(String line) {
        return line.split("\t", -1);
    }

    public Class<PasteDataCommand> getCommandClass() {
        return PasteDataCommand.class;
    }
}

