/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.ChangePrimitiveParameterCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.AbstractPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.InputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.OutputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.widgets.InterfaceSelectorButton;
import org.eclipse.fordiac.ide.gef.properties.AbstractDoubleColumnSection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractPrimitiveSection
extends AbstractDoubleColumnSection {
    private Text parametersText;
    private CCombo eventCombo;
    private CCombo dataQualifyingCombo;
    private Button checkBox;
    private Text customEventText;
    private InterfaceSelectorButton interfaceSelector;
    private static final int ASCII_UNDERSCORE = 95;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Group primitiveSpecification = this.getWidgetFactory().createGroup(this.getLeftComposite(), Messages.PrimitiveSection_CreateControls_PrimitiveSpecification);
        primitiveSpecification.setLayout((Layout)new GridLayout());
        primitiveSpecification.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createEventSection(primitiveSpecification);
        this.createCustomEventSection((Composite)primitiveSpecification);
        this.createPrimitiveSection(primitiveSpecification);
        this.fillDataQualifyingDropdown();
        this.dataQualifyingCombo.setToolTipText(Messages.PrimitiveSection_DataQualifyingToolTip);
    }

    protected void createEventSection(Group parent) {
        Composite composite = this.getWidgetFactory().createComposite((Composite)parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        composite.pack();
        this.getWidgetFactory().createCLabel(composite, Messages.PrimitiveSection_CreateEventSection_Event);
        Composite eventComposite = this.getWidgetFactory().createComposite(composite);
        eventComposite.setLayout((Layout)new GridLayout(1, true));
        eventComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.eventCombo = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)eventComposite);
        this.eventCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.eventCombo.addListener(13, event -> {
            String newEventName = this.eventCombo.getText() + this.dataQualifyingCombo.getText();
            this.executeCommand(new ChangePrimitiveEventCommand(this.getType(), newEventName));
            this.refresh();
        });
        Composite dataQualifyingComposite = this.getWidgetFactory().createComposite(composite);
        dataQualifyingComposite.setLayout((Layout)new GridLayout(1, true));
        dataQualifyingComposite.setLayoutData((Object)new GridData(131072, 0, false, false));
        dataQualifyingComposite.setSize(85, this.getMinimumHeight());
        dataQualifyingComposite.setToolTipText(Messages.PrimitiveSection_DataQualifyingToolTip);
        this.dataQualifyingCombo = ComboBoxWidgetFactory.createCombo((TabbedPropertySheetWidgetFactory)this.getWidgetFactory(), (Composite)dataQualifyingComposite);
        this.dataQualifyingCombo.setLayoutData((Object)new GridData(4, 4, false, false));
        this.dataQualifyingCombo.addListener(13, event -> {
            String newEventName = this.eventCombo.getText() + this.dataQualifyingCombo.getText();
            this.executeCommand(new ChangePrimitiveEventCommand(this.getType(), newEventName));
            this.refresh();
        });
    }

    private void createCustomEventSection(Composite parent) {
        Composite customEventComposite = this.getWidgetFactory().createComposite(parent);
        customEventComposite.setLayout((Layout)new GridLayout(3, false));
        customEventComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(customEventComposite, Messages.PrimitiveSection_CustomEvent);
        this.checkBox = new Button(customEventComposite, 32);
        this.customEventText = this.createGroupText(customEventComposite, true);
        if (this.isCustomEvent()) {
            this.checkBox.setSelection(true);
        }
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractPrimitiveSection.this.checkBox.getSelection()) {
                    AbstractPrimitiveSection.this.executeCommand(new ChangePrimitiveEventCommand(AbstractPrimitiveSection.this.getType(), ""));
                } else {
                    AbstractPrimitiveSection.this.customEventText.setText("");
                    AbstractPrimitiveSection.this.eventCombo.select(0);
                    AbstractPrimitiveSection.this.executeCommand(new ChangePrimitiveEventCommand(AbstractPrimitiveSection.this.getType(), AbstractPrimitiveSection.this.eventCombo.getText()));
                }
                AbstractPrimitiveSection.this.refresh();
            }
        });
        this.customEventText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangePrimitiveEventCommand(this.getType(), this.customEventText.getText()));
            this.addContentAdapter();
        });
    }

    private boolean isCustomEvent() {
        if (this.getType() != null) {
            FBType fb = this.getFBType();
            for (Event event : this.getRelevantEvents(fb)) {
                if (!event.getName().equals(this.getType().getEvent())) continue;
                return false;
            }
        }
        return true;
    }

    protected void createPrimitiveSection(Group parent) {
        Composite composite = this.getWidgetFactory().createComposite((Composite)parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, Messages.PrimitiveSection_CreatePrimitiveSection_Interface);
        this.interfaceSelector = new InterfaceSelectorButton(composite, cmd -> {
            this.executeCommand((Command)cmd);
            this.refresh();
        });
        this.getWidgetFactory().createCLabel(composite, Messages.TransactionSection_Parameter);
        this.parametersText = this.createGroupText(composite, true, 2626);
        this.parametersText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand(new ChangePrimitiveParameterCommand(this.getType(), this.parametersText.getText()));
            this.addContentAdapter();
        });
    }

    protected Primitive getInputType(Object input) {
        if (input instanceof InputPrimitiveEditPart || input instanceof OutputPrimitiveEditPart) {
            return ((AbstractPrimitiveEditPart)((Object)input)).getModel();
        }
        if (input instanceof InputPrimitive || input instanceof OutputPrimitive) {
            return (Primitive)input;
        }
        return null;
    }

    protected void setInputCode() {
        this.parametersText.setEnabled(false);
    }

    protected void performRefresh() {
        this.parametersText.setText(this.getType().getParameters() != null ? this.getType().getParameters() : "");
        this.interfaceSelector.setType(this.getType());
        this.setEventDropdown();
        this.setDataQualifyingDropdown();
        IInterfaceElement qiData = this.getType().getService().getFBType().getInterfaceList().getInterfaceElement(List.of("QI"));
        this.dataQualifyingCombo.setEnabled(qiData != null && !this.checkBox.getSelection());
        this.customEventText.setEnabled(this.checkBox.getSelection());
        this.eventCombo.setEnabled(!this.checkBox.getSelection());
    }

    protected abstract EList<Event> getRelevantEvents(FBType var1);

    protected abstract Primitive getType();

    protected FBType getFBType() {
        return this.getType().getService().getFBType();
    }

    private void fillDataQualifyingDropdown() {
        this.dataQualifyingCombo.removeAll();
        this.dataQualifyingCombo.add("");
        this.dataQualifyingCombo.add("+");
        this.dataQualifyingCombo.add("-");
    }

    private void setDataQualifyingDropdown() {
        String currentEvent = this.getType().getEvent();
        int index = 0;
        if (!currentEvent.isEmpty()) {
            String lastChar = String.valueOf(currentEvent.charAt(currentEvent.length() - 1));
            String[] itemsArray = this.dataQualifyingCombo.getItems();
            int i = 0;
            while (i < itemsArray.length) {
                if (lastChar.equals(itemsArray[i])) {
                    index = i;
                }
                ++i;
            }
        }
        this.dataQualifyingCombo.select(index);
    }

    public void setEventDropdown() {
        this.eventCombo.removeAll();
        FBType fb = this.getFBType();
        for (Event event : this.getRelevantEvents(fb)) {
            this.eventCombo.add(event.getName());
        }
        this.selectCurrentEventInCombo();
    }

    private void selectCurrentEventInCombo() {
        int index;
        char lastChar;
        String currentEvent = this.getType().getEvent();
        if (!currentEvent.isEmpty() && !Character.isLetterOrDigit(lastChar = currentEvent.charAt(currentEvent.length() - 1)) && lastChar != '_') {
            currentEvent = currentEvent.substring(0, currentEvent.length() - 1);
        }
        if ((index = Arrays.asList(this.eventCombo.getItems()).indexOf(currentEvent)) >= 0) {
            this.eventCombo.select(index);
            this.checkBox.setSelection(false);
            this.customEventText.setText("");
        } else {
            this.checkBox.setSelection(true);
            this.customEventText.setText(currentEvent);
        }
    }
}

