/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.function.Function;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComplianceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ComplianceUtils.class);

    public static boolean allows(ComplianceViolation.Mode compliance, ComplianceViolation violation, ComplianceViolation.Listener complianceListener) {
        return ComplianceUtils.allows(compliance, violation, violation.getDescription(), complianceListener);
    }

    public static boolean allows(ComplianceViolation.Mode compliance, ComplianceViolation violation, String detail, ComplianceViolation.Listener complianceListener) {
        boolean allowed = compliance.allows(violation);
        ComplianceUtils.notify(complianceListener, new ComplianceViolation.Event(compliance, violation, detail, allowed));
        return allowed;
    }

    public static void notify(ComplianceViolation.Listener complianceListener, ComplianceViolation.Event event) {
        block4: {
            if (complianceListener == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().log("Unable to notify null ComplianceViolation.Listener of {}", (Object)event);
                }
                return;
            }
            try {
                complianceListener.onComplianceViolation(event);
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.atDebug().setCause(x).log("Failure while notifying listener {} of event {}", (Object)complianceListener, (Object)event);
            }
        }
    }

    public static <T extends Throwable> void verify(UriCompliance uriCompliance, HttpURI uri, ComplianceViolation.Listener listener, Function<String, T> error) throws T {
        if (!uri.hasViolations()) {
            return;
        }
        StringBuilder violations = null;
        for (UriCompliance.Violation violation : uri.getViolations()) {
            boolean allowed = ComplianceUtils.allows(uriCompliance, violation, violation.getDescription(), listener);
            if (allowed) continue;
            if (violations == null) {
                violations = new StringBuilder();
            } else {
                violations.append(", ");
            }
            violations.append(violation.getDescription());
        }
        if (violations != null) {
            throw (Throwable)error.apply(violations.toString());
        }
    }

    public static void verify(HttpCompliance httpCompliance, MetaData.Request request, ComplianceViolation.Listener listener) {
        boolean seenContentLength = false;
        boolean seenTransferEncoding = false;
        boolean seenHostHeader = false;
        HttpFields fields = request.getHttpFields();
        for (HttpField httpField : fields) {
            if (httpField.getHeader() == null) continue;
            switch (httpField.getHeader()) {
                case CONTENT_LENGTH: {
                    if (seenContentLength && !ComplianceUtils.allows(httpCompliance, HttpCompliance.Violation.MULTIPLE_CONTENT_LENGTHS, listener)) {
                        throw new HttpException.RuntimeException(400, HttpCompliance.Violation.MULTIPLE_CONTENT_LENGTHS.getDescription());
                    }
                    String[] lengths = httpField.getValues();
                    if (lengths.length > 1 && !ComplianceUtils.allows(httpCompliance, HttpCompliance.Violation.MULTIPLE_CONTENT_LENGTHS, listener)) {
                        throw new HttpException.RuntimeException(400, HttpCompliance.Violation.MULTIPLE_CONTENT_LENGTHS.getDescription());
                    }
                    if (seenTransferEncoding && !ComplianceUtils.allows(httpCompliance, HttpCompliance.Violation.TRANSFER_ENCODING_WITH_CONTENT_LENGTH, listener)) {
                        throw new HttpException.RuntimeException(400, HttpCompliance.Violation.TRANSFER_ENCODING_WITH_CONTENT_LENGTH.getDescription());
                    }
                    seenContentLength = true;
                    break;
                }
                case TRANSFER_ENCODING: {
                    if (seenContentLength && !ComplianceUtils.allows(httpCompliance, HttpCompliance.Violation.TRANSFER_ENCODING_WITH_CONTENT_LENGTH, listener)) {
                        throw new HttpException.RuntimeException(400, HttpCompliance.Violation.TRANSFER_ENCODING_WITH_CONTENT_LENGTH.getDescription());
                    }
                    seenTransferEncoding = true;
                    break;
                }
                case HOST: {
                    if (seenHostHeader && !ComplianceUtils.allows(httpCompliance, HttpCompliance.Violation.DUPLICATE_HOST_HEADERS, listener)) {
                        throw new HttpException.RuntimeException(400, HttpCompliance.Violation.DUPLICATE_HOST_HEADERS.getDescription());
                    }
                    String[] hostValues = httpField.getValues();
                    if (hostValues.length > 1 && !ComplianceUtils.allows(httpCompliance, HttpCompliance.Violation.DUPLICATE_HOST_HEADERS, listener)) {
                        throw new HttpException.RuntimeException(400, HttpCompliance.Violation.DUPLICATE_HOST_HEADERS.getDescription());
                    }
                    for (String hostValue : hostValues) {
                        if (!StringUtil.isBlank((String)hostValue) || ComplianceUtils.allows(httpCompliance, HttpCompliance.Violation.UNSAFE_HOST_HEADER, listener)) continue;
                        throw new HttpException.RuntimeException(400, HttpCompliance.Violation.UNSAFE_HOST_HEADER.getDescription());
                    }
                    seenHostHeader = true;
                }
            }
        }
    }
}

