/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.logical;

import com.google.common.base.Preconditions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.compare.ide.internal.logical.AbstractModelInclusionTester;

public class ContentTypeModelInclusionTester
extends AbstractModelInclusionTester {
    private IContentType contentType;

    public ContentTypeModelInclusionTester(String contentType, String key) {
        super(key);
        IContentType aContentType = Platform.getContentTypeManager().getContentType(contentType);
        this.contentType = (IContentType)Preconditions.checkNotNull((Object)aContentType);
    }

    @Override
    public boolean shouldInclude(IFile file) {
        if (file != null) {
            IContentType[] iContentTypeArray = Platform.getContentTypeManager().findContentTypesFor(file.getFullPath().toString());
            int n = iContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType fileContentType = iContentTypeArray[n2];
                if (fileContentType != null && fileContentType.isKindOf(this.contentType)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

