/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInterfaceOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderToolbarWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.ISelectionProviderSection;
import org.eclipse.fordiac.ide.ui.widget.SelectionProviderProxy;
import org.eclipse.fordiac.ide.ui.widget.nattable.I4diacNatTableUtil;
import org.eclipse.fordiac.ide.ui.widget.nattable.IChangeableRowDataProvider;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.RowPostSelectionProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractEditInterfaceSection<T extends IInterfaceElement>
extends AbstractSection
implements I4diacNatTableUtil,
ISelectionProviderSection {
    protected IChangeableRowDataProvider<T> inputProvider;
    protected NatTable inputTable;
    private AddDeleteReorderToolbarWidget inputButtons;
    private RowPostSelectionProvider<T> inputSelectionProvider;
    protected IChangeableRowDataProvider<T> outputProvider;
    protected NatTable outputTable;
    private AddDeleteReorderToolbarWidget outputButtons;
    private RowPostSelectionProvider<T> outputSelectionProvider;
    private SelectionProvider selectionProvider;
    private final Adapter interfaceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            AbstractEditInterfaceSection.this.notifiyRefresh();
        }
    };
    private final IEditableRule sectionEditableRule = new IEditableRule(){

        public boolean isEditable(int columnIndex, int rowIndex) {
            return AbstractEditInterfaceSection.this.isEditable();
        }

        public boolean isEditable(ILayerCell cell, IConfigRegistry configRegistry) {
            return AbstractEditInterfaceSection.this.isEditable();
        }
    };

    protected abstract CreationCommand newCreateCommand(IInterfaceElement var1, boolean var2);

    protected abstract CreationCommand newInsertCommand(IInterfaceElement var1, boolean var2, int var3);

    protected abstract DeleteInterfaceCommand newDeleteCommand(IInterfaceElement var1);

    protected abstract ChangeInterfaceOrderCommand newOrderCommand(IInterfaceElement var1, boolean var2);

    protected abstract void setupOutputTable(Group var1);

    protected abstract void setupInputTable(Group var1);

    protected abstract INamedElement getInputType(Object var1);

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(3, false));
        this.createInputOutputEdit(parent);
    }

    private void createInputOutputEdit(Composite parent) {
        Group inputsGroup = this.getWidgetFactory().createGroup(parent, "Inputs");
        inputsGroup.setLayout((Layout)new GridLayout(2, false));
        inputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Group outputsGroup = this.getWidgetFactory().createGroup(parent, "Outputs");
        outputsGroup.setLayout((Layout)new GridLayout(2, false));
        outputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.inputButtons = new AddDeleteReorderToolbarWidget();
        this.outputButtons = new AddDeleteReorderToolbarWidget();
        if (this.isShowTableEditButtons()) {
            this.inputButtons.createControls((Composite)inputsGroup, (FormToolkit)this.getWidgetFactory());
            this.outputButtons.createControls((Composite)outputsGroup, (FormToolkit)this.getWidgetFactory());
        }
        this.setupInputTable(inputsGroup);
        this.setupOutputTable(outputsGroup);
        if (this.isShowTableEditButtons()) {
            this.configureButtonList((AddDeleteReorderListWidget)this.inputButtons, this.inputTable, true);
            this.configureButtonList((AddDeleteReorderListWidget)this.outputButtons, this.outputTable, false);
        }
        this.inputSelectionProvider = new RowPostSelectionProvider(this.inputTable, NatTableWidgetFactory.getSelectionLayer((NatTable)this.inputTable), this.inputProvider, false);
        this.outputSelectionProvider = new RowPostSelectionProvider(this.outputTable, NatTableWidgetFactory.getSelectionLayer((NatTable)this.outputTable), this.outputProvider, false);
        this.selectionProvider = new SelectionProvider();
        this.inputTable.addFocusListener((FocusListener)this.selectionProvider);
        this.outputTable.addFocusListener((FocusListener)this.selectionProvider);
    }

    private void configureButtonList(AddDeleteReorderListWidget buttons, NatTable table, boolean inputs) {
        buttons.bindToTableViewer(table, (CommandExecutor)this, ref -> this.newCreateCommand((IInterfaceElement)ref, inputs), ref -> this.newDeleteCommand((IInterfaceElement)ref), ref -> this.newOrderCommand((IInterfaceElement)ref, true), ref -> this.newOrderCommand((IInterfaceElement)ref, false));
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.inputButtons != null) {
            this.inputButtons.dispose();
        }
        if (this.outputButtons != null) {
            this.outputButtons.dispose();
        }
    }

    @Override
    protected void performRefresh() {
        this.setTableInput();
        this.inputTable.refresh();
        this.outputTable.refresh();
    }

    @Override
    protected void performRefreshAnnotations() {
        this.inputTable.refresh(false);
        this.outputTable.refresh(false);
    }

    protected void setTableInput() {
        this.setTableInput(this.getInterface());
        if (this.isShowTableEditButtons()) {
            this.inputButtons.setEnabled(this.isEditable());
            this.outputButtons.setEnabled(this.isEditable());
        }
    }

    protected abstract void setTableInput(InterfaceList var1);

    protected int getInsertingIndex(IInterfaceElement interfaceElement, EList<? extends IInterfaceElement> interfaceList) {
        return interfaceList.indexOf((Object)interfaceElement) + 1;
    }

    protected abstract int getInsertingIndex(IInterfaceElement var1, boolean var2);

    protected String getCreationName(IInterfaceElement interfaceElement) {
        return interfaceElement != null ? interfaceElement.getName() : null;
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.executeCommand((Command)cmd);
        this.inputTable.refresh();
        this.outputTable.refresh();
    }

    @Override
    protected void addContentAdapter() {
        InterfaceList interfaceList;
        super.addContentAdapter();
        if (this.isEditable() && (interfaceList = this.getInterface()) != null) {
            interfaceList.eAdapters().add((Object)this.interfaceAdapter);
        }
    }

    @Override
    protected void removeContentAdapter() {
        InterfaceList interfaceList;
        super.removeContentAdapter();
        if (this.isEditable() && (interfaceList = this.getInterface()) != null) {
            this.getInterface().eAdapters().remove((Object)this.interfaceAdapter);
        }
    }

    protected abstract InterfaceList getInterface();

    public boolean isEditable() {
        return !(EcoreUtil.getRootContainer((EObject)this.getType()) instanceof FunctionFBType);
    }

    public boolean isShowTableEditButtons() {
        return true;
    }

    protected IEditableRule getSectionEditableRule() {
        return this.sectionEditableRule;
    }

    public Command onNameChange(IInterfaceElement rowObject, String newValue) {
        return ChangeNameCommand.forName((INamedElement)rowObject, (String)newValue);
    }

    public SelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    private class SelectionProvider
    extends SelectionProviderProxy
    implements FocusListener {
        private SelectionProvider() {
        }

        public void focusGained(FocusEvent e) {
            if (e.widget == AbstractEditInterfaceSection.this.inputTable) {
                this.setDelegate((ISelectionProvider)AbstractEditInterfaceSection.this.inputSelectionProvider);
            } else if (e.widget == AbstractEditInterfaceSection.this.outputTable) {
                this.setDelegate((ISelectionProvider)AbstractEditInterfaceSection.this.outputSelectionProvider);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

