/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.widgets;

import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.editors.TypeDeclarationEditor;
import org.eclipse.fordiac.ide.gef.widgets.TypeSelectionWidget;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class PinInfoBasicWidget
implements CommandExecutor {
    private Text nameText;
    private Text commentText;
    private TypeSelectionWidget typeSelectionWidget;
    private TypeDeclarationEditor typeDeclarationEditor;
    private IInterfaceElement type;
    protected final TabbedPropertySheetWidgetFactory widgetFactory;
    protected Consumer<Command> commandExecutor;

    public PinInfoBasicWidget(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
        this.createWidget(parent);
    }

    protected void createWidget(Composite parent) {
        GridLayoutFactory.swtDefaults().numColumns(2).generateLayout(parent);
        this.widgetFactory.createCLabel(parent, FordiacMessages.Name + ":");
        this.nameText = this.createText(parent);
        this.nameText.addModifyListener(e -> this.onNameChange(this.nameText));
        this.widgetFactory.createCLabel(parent, FordiacMessages.Comment + ":");
        this.commentText = this.createText(parent);
        this.commentText.addModifyListener(e -> this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.type, this.commentText.getText())));
        this.widgetFactory.createCLabel(parent, FordiacMessages.Type + ":");
        this.typeSelectionWidget = new TypeSelectionWidget(this.widgetFactory, this::handleTypeSelectionChanged);
        this.typeSelectionWidget.createControls(parent);
        this.typeDeclarationEditor = new TypeDeclarationEditor(parent, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.typeDeclarationEditor.getControl());
    }

    protected Text createText(Composite parent) {
        Text text = this.widgetFactory.createText(parent, "", 2048);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        text.setEditable(true);
        text.setEnabled(true);
        return text;
    }

    public void disableAllFields() {
        this.nameText.setEnabled(false);
        this.commentText.setEnabled(false);
    }

    public void refresh() {
        if (this.type != null) {
            Consumer<Command> commandExecutorBuffer = this.commandExecutor;
            this.commandExecutor = null;
            if (this.type.getName() != null && this.type.getComment() != null) {
                this.nameText.setText(this.type.getName());
                this.commentText.setText(this.type.getComment());
            }
            this.typeSelectionWidget.refresh();
            this.typeDeclarationEditor.refresh();
            this.checkFieldEnablements();
            this.commandExecutor = commandExecutorBuffer;
        }
    }

    public void initialize(IInterfaceElement type, Consumer<Command> commandExecutor) {
        this.type = type;
        this.commandExecutor = commandExecutor;
        this.typeDeclarationEditor.setInterfaceElement(type);
        this.typeDeclarationEditor.setCommandExecutor(commandExecutor);
    }

    public void executeCommand(Command cmd) {
        if (this.commandExecutor != null) {
            this.commandExecutor.accept(cmd);
        }
    }

    protected void checkFieldEnablements() {
        this.nameText.setEditable(this.isEditable());
        this.commentText.setEditable(this.isEditable());
        this.typeSelectionWidget.setEditable(this.isTypeChangeable());
        this.typeSelectionWidget.getControl().setVisible(true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.typeSelectionWidget.getControl());
        this.typeDeclarationEditor.setEditable(false);
        this.typeDeclarationEditor.getControl().setVisible(false);
        GridDataFactory.swtDefaults().exclude(true).applyTo((Control)this.typeDeclarationEditor.getControl());
    }

    protected boolean isEditable() {
        return !(EcoreUtil.getRootContainer((EObject)this.getType()) instanceof FunctionFBType);
    }

    protected boolean isTypeChangeable() {
        return this.isEditable();
    }

    public IInterfaceElement getType() {
        return this.type;
    }

    public TypeSelectionWidget getTypeSelectionWidget() {
        return this.typeSelectionWidget;
    }

    protected TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    private void handleTypeSelectionChanged(String newTypeName) {
        if (this.isTypeChangeable()) {
            this.executeCommand((Command)ChangeDataTypeCommand.forTypeDeclaration((IInterfaceElement)this.getType(), (String)newTypeName));
            Consumer<Command> commandExecutorBuffer = this.commandExecutor;
            this.commandExecutor = null;
            this.refresh();
            this.commandExecutor = commandExecutorBuffer;
        }
    }

    protected void onNameChange(Text name) {
        this.executeCommand((Command)ChangeNameCommand.forName((INamedElement)this.type, (String)name.getText()));
    }
}

