/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.document;

import com.google.inject.Inject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.LibraryElementXtextResourceMarkerAnnotationModel;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.util.IssueUtil;

public abstract class LibraryElementXtextDocumentProvider
extends XtextDocumentProvider {
    @Inject
    private LanguageInfo languageInfo;
    @Inject
    private AbstractUIPlugin languageUIPlugin;
    @Inject
    private IssueResolutionProvider issueResolutionProvider;
    @Inject
    private IssueUtil issueUtil;

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        IFileEditorInput fileEditorInput;
        TypeEntry typeEntry;
        LibraryElement libraryElement = LibraryElementProvider.INSTANCE.getLibraryElement(editorInput);
        if (libraryElement != null) {
            this.setDocumentContent(document, libraryElement);
            this.setDocumentResource((XtextDocument)document, editorInput, encoding);
            return true;
        }
        if (editorInput instanceof IFileEditorInput && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile((fileEditorInput = (IFileEditorInput)editorInput).getFile())) != null) {
            this.setDocumentContent(document, typeEntry.getType());
            this.setDocumentResource((XtextDocument)document, editorInput, encoding);
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return new LibraryElementXtextResourceMarkerAnnotationModel(input.getFile(), this.issueResolutionProvider, this.issueUtil, this.getLanguageMarkerType());
        }
        return super.createAnnotationModel(element);
    }

    protected String getLanguageMarkerType() {
        return this.languageUIPlugin.getBundle().getSymbolicName() + "." + this.languageInfo.getShortName().toLowerCase();
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)element;
            LibraryElement libraryElement = LibraryElementProvider.INSTANCE.getLibraryElement((IEditorInput)fileEditorInput);
            if (libraryElement != null) {
                this.doSaveDocument(monitor, fileEditorInput, libraryElement, (XtextDocument)document);
                this.updateFileInfo(fileEditorInput);
                return;
            }
            TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(fileEditorInput.getFile());
            if (typeEntry != null && (libraryElement = typeEntry.copyType()) != null) {
                this.doSaveDocument(monitor, fileEditorInput, libraryElement, (XtextDocument)document);
                typeEntry.save(libraryElement, monitor);
                this.updateFileInfo(fileEditorInput);
                return;
            }
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }

    protected void updateFileInfo(IFileEditorInput fileEditorInput) throws CoreException {
        FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(fileEditorInput);
        if (info != null) {
            IAnnotationModel model = info.fModel;
            if (model instanceof ResourceMarkerAnnotationModel) {
                ResourceMarkerAnnotationModel resourceMarkerAnnotationModel = (ResourceMarkerAnnotationModel)model;
                resourceMarkerAnnotationModel.updateMarkers(info.fDocument);
            }
            info.fModificationStamp = this.computeModificationStamp((IResource)fileEditorInput.getFile());
        }
    }

    public boolean isSynchronized(Object element) {
        IEditorInput editorInput;
        if (element instanceof IEditorInput && LibraryElementProvider.INSTANCE.getLibraryElement(editorInput = (IEditorInput)element) != null) {
            return LibraryElementProvider.INSTANCE.isSynchronized(editorInput);
        }
        return super.isSynchronized(element);
    }

    protected void handleElementContentChanged(IFileEditorInput fileEditorInput) {
        TypeEntry typeEntry;
        if (LibraryElementProvider.INSTANCE.getLibraryElement((IEditorInput)fileEditorInput) != null) {
            return;
        }
        FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(fileEditorInput);
        if (info == null) {
            return;
        }
        XtextDocument document = (XtextDocument)info.fDocument;
        super.handleElementContentChanged(fileEditorInput);
        if (document == info.fDocument && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(fileEditorInput.getFile())) != null) {
            LibraryElement libraryElement = typeEntry.getType();
            this.removeUnchangedElementListeners(fileEditorInput, (AbstractDocumentProvider.ElementInfo)info);
            document.internalModify(resource -> {
                if (resource instanceof LibraryElementXtextResource) {
                    LibraryElementXtextResource libResource = (LibraryElementXtextResource)resource;
                    libResource.setLibraryElement(libraryElement);
                }
                return null;
            });
            this.addUnchangedElementListeners(fileEditorInput, (AbstractDocumentProvider.ElementInfo)info);
        }
    }

    public abstract void doSaveDocument(IProgressMonitor var1, IFileEditorInput var2, LibraryElement var3, XtextDocument var4) throws CoreException;

    public abstract void setDocumentContent(IDocument var1, LibraryElement var2) throws CoreException;
}

