/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.search.ModelQuerySpec;
import org.eclipse.fordiac.ide.model.search.ModelSearchQuery;
import org.eclipse.fordiac.ide.model.search.ModelSearchResult;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class SearchTypeReferences
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        TypeEntry typeEntry = SearchTypeReferences.getTypeEntryFromSelection(selection);
        if (typeEntry != null) {
            ModelQuerySpec searchSpec = new ModelQuerySpec(typeEntry.getFullTypeName(), false, false, true, false, false, true, false, ModelQuerySpec.SearchScope.PROJECT, (IResource)typeEntry.getFile().getProject(), null);
            ModelSearchQuery query = SearchTypeReferences.createModelSearchQuery(typeEntry, searchSpec);
            NewSearchUI.runQueryInBackground((ISearchQuery)query, (ISearchResultViewPart)NewSearchUI.getSearchResultView());
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(SearchTypeReferences.getTypeEntryFromSelection(selection) != null);
    }

    private static TypeEntry getTypeEntryFromSelection(Object selection) {
        IFile file;
        TypeEntry typeEntry;
        Object object;
        StructuredSelection structSel;
        if (selection instanceof StructuredSelection && !(structSel = (StructuredSelection)selection).isEmpty() && (object = structSel.getFirstElement()) instanceof IFile && ((typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file = (IFile)object)) instanceof DataTypeEntry || typeEntry instanceof FBTypeEntry || typeEntry instanceof SubAppTypeEntry)) {
            return typeEntry;
        }
        return null;
    }

    private static ModelSearchQuery createModelSearchQuery(final TypeEntry typeEntry, ModelQuerySpec searchSpec) {
        return new ModelSearchQuery(searchSpec){

            @Override
            protected ModelSearchResult createModelSearchResult() {
                return new ModelSearchResult(this){

                    @Override
                    public void addResult(EObject res) {
                        LibraryElement libEl;
                        if (res instanceof LibraryElement && typeEntry.equals((libEl = (LibraryElement)res).getTypeEntry())) {
                            return;
                        }
                        super.addResult(res);
                    }
                };
            }
        };
    }
}

