/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateTransactionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.AbstractPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.InputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.OutputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.TransactionEditPart;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.model.commands.change.ChangeOutputPrimitiveOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeServiceSequenceOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTransactionOrderCommand;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ServiceTransactionImpl;
import org.eclipse.fordiac.ide.model.libraryElement.impl.SimpleFBTypeImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class TransactionLayoutEditPolicy
extends FlowLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new ModifiedNonResizeableEditPolicy(3, new Insets(1));
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object type = request.getNewObjectType();
        EditPart refEP = this.getInsertionReference((Request)request);
        if ("LeftOutputPrimitive".equals(type)) {
            return this.createLeftOutputPrimitive(refEP);
        }
        if ("ServiceTransaction".equals(type)) {
            return this.createServiceTransaction(refEP);
        }
        if ("ServiceSequence".equals(type)) {
            return this.createServiceSequence(refEP);
        }
        return null;
    }

    private Command createLeftOutputPrimitive(EditPart refEP) {
        if (refEP instanceof OutputPrimitiveEditPart) {
            ServiceTransaction transaction = ((OutputPrimitive)refEP.getModel()).getServiceTransaction();
            int index = transaction.getOutputPrimitive().indexOf(refEP.getModel());
            return new CreateOutputPrimitiveCommand(transaction, index, true);
        }
        if (refEP instanceof InputPrimitiveEditPart) {
            ServiceTransaction transaction = ((InputPrimitive)refEP.getModel()).getServiceTransaction();
            return new CreateOutputPrimitiveCommand(transaction, 0, true);
        }
        if (refEP instanceof TransactionEditPart) {
            ServiceTransaction transaction = (ServiceTransaction)refEP.getModel();
            int index = transaction.getOutputPrimitive().size();
            return new CreateOutputPrimitiveCommand(transaction, index, true);
        }
        if (refEP instanceof ServiceSequenceEditPart) {
            int sequenceBefore = ((ServiceSequence)refEP.getModel()).getService().getServiceSequence().indexOf(refEP.getModel()) - 1;
            if (sequenceBefore < 0) {
                sequenceBefore = 0;
            }
            ServiceSequence sequence = (ServiceSequence)((ServiceSequence)refEP.getModel()).getService().getServiceSequence().get(sequenceBefore);
            ServiceTransaction transaction = (ServiceTransaction)sequence.getServiceTransaction().get(sequence.getServiceTransaction().size() - 1);
            int index = transaction.getOutputPrimitive().size();
            return new CreateOutputPrimitiveCommand(transaction, index, true);
        }
        if (refEP == null) {
            ServiceTransaction transaction = (ServiceTransaction)this.getHost().getModel();
            return new CreateOutputPrimitiveCommand(transaction, true);
        }
        return null;
    }

    private Command createServiceTransaction(EditPart refEP) {
        if (refEP instanceof AbstractPrimitiveEditPart) {
            ServiceSequence sequence = ((Primitive)refEP.getModel()).getServiceTransaction().getServiceSequence();
            ServiceTransaction refElement = ((Primitive)refEP.getModel()).getServiceTransaction();
            return new CreateTransactionCommand(sequence, refElement);
        }
        if (refEP instanceof TransactionEditPart) {
            ServiceSequence sequence = ((ServiceTransaction)refEP.getModel()).getServiceSequence();
            int indexLastTransaction = sequence.getServiceTransaction().size() - 1;
            return new CreateTransactionCommand(sequence, (ServiceTransaction)sequence.getServiceTransaction().get(indexLastTransaction));
        }
        if (refEP instanceof ServiceSequenceEditPart) {
            ServiceSequence sequenceBefore;
            int indexLastTransaction;
            int indexSequenceBefore = ((ServiceSequence)refEP.getModel()).getService().getServiceSequence().indexOf(refEP.getModel()) - 1;
            if (indexSequenceBefore < 0) {
                indexSequenceBefore = 0;
            }
            if ((indexLastTransaction = (sequenceBefore = (ServiceSequence)((ServiceSequence)refEP.getModel()).getService().getServiceSequence().get(indexSequenceBefore)).getServiceTransaction().size() - 1) < 0) {
                indexLastTransaction = 0;
            }
            ServiceTransaction transaction = (ServiceTransaction)sequenceBefore.getServiceTransaction().get(indexLastTransaction);
            return new CreateTransactionCommand(sequenceBefore, transaction);
        }
        if (refEP == null) {
            ServiceTransaction transaction = (ServiceTransaction)this.getHost().getModel();
            return new CreateTransactionCommand(transaction.getServiceSequence(), transaction);
        }
        return null;
    }

    private Command createServiceSequence(EditPart refEP) {
        if (refEP instanceof AbstractPrimitiveEditPart) {
            Service service = ((Primitive)refEP.getModel()).getService();
            ServiceSequence sequence = ((Primitive)refEP.getModel()).getServiceTransaction().getServiceSequence();
            return new CreateServiceSequenceCommand(service, sequence);
        }
        if (refEP instanceof TransactionEditPart) {
            Service service = ((ServiceTransaction)refEP.getModel()).getServiceSequence().getService();
            return new CreateServiceSequenceCommand(service, ((ServiceTransaction)refEP.getModel()).getServiceSequence());
        }
        if (refEP instanceof ServiceSequenceEditPart) {
            ServiceSequence sequence = (ServiceSequence)refEP.getModel();
            int indexSequenceBefore = sequence.getService().getServiceSequence().indexOf((Object)sequence) - 1;
            if (indexSequenceBefore < 0) {
                indexSequenceBefore = 0;
            }
            return new CreateServiceSequenceCommand(sequence.getService(), (ServiceSequence)sequence.getService().getServiceSequence().get(indexSequenceBefore));
        }
        if (refEP == null) {
            if (this.getHost().getModel() instanceof SimpleFBTypeImpl) {
                SimpleFBTypeImpl fb = (SimpleFBTypeImpl)this.getHost().getModel();
                Service service = fb.getService();
                int indexLastSequence = service.getServiceSequence().size() - 1;
                return new CreateServiceSequenceCommand(service, (ServiceSequence)service.getServiceSequence().get(indexLastSequence));
            }
            if (this.getHost().getModel() instanceof ServiceTransactionImpl) {
                ServiceTransactionImpl serviceTransactionImpl = (ServiceTransactionImpl)this.getHost().getModel();
                Service service = serviceTransactionImpl.getServiceSequence().getService();
                int indexSequenceBefore = service.getServiceSequence().indexOf((Object)serviceTransactionImpl.getServiceSequence());
                return new CreateServiceSequenceCommand(service, (ServiceSequence)service.getServiceSequence().get(indexSequenceBefore));
            }
            return null;
        }
        return null;
    }

    protected boolean isLayoutHorizontal() {
        return false;
    }

    protected Command createAddCommand(EditPart child, EditPart after) {
        return null;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        if (child instanceof OutputPrimitiveEditPart) {
            return TransactionLayoutEditPolicy.moveOutputPrimitive(child, after);
        }
        if (child instanceof TransactionEditPart) {
            return TransactionLayoutEditPolicy.moveTransaction(child, after);
        }
        if (child instanceof ServiceSequenceEditPart) {
            return this.moveServiceSequence(child, after);
        }
        return null;
    }

    private static Command moveOutputPrimitive(EditPart child, EditPart after) {
        OutputPrimitive afterOutputP;
        OutputPrimitive outputP = (OutputPrimitive)child.getModel();
        if (after instanceof InputPrimitiveEditPart) {
            return new ChangeOutputPrimitiveOrderCommand(outputP, 0);
        }
        if (after instanceof OutputPrimitiveEditPart && (afterOutputP = (OutputPrimitive)after.getModel()).getServiceTransaction().equals(outputP.getServiceTransaction())) {
            return new ChangeOutputPrimitiveOrderCommand(outputP, afterOutputP, false);
        }
        return null;
    }

    private static Command moveTransaction(EditPart child, EditPart after) {
        ServiceTransaction transaction = (ServiceTransaction)child.getModel();
        if (after instanceof AbstractPrimitiveEditPart) {
            ServiceTransaction afterT = ((Primitive)after).getServiceTransaction();
            return new ChangeTransactionOrderCommand(transaction, afterT, false);
        }
        if (after instanceof TransactionEditPart) {
            ServiceTransaction afterT = (ServiceTransaction)after.getModel();
            if (transaction.getServiceSequence().equals(afterT.getServiceSequence())) {
                return new ChangeTransactionOrderCommand(transaction, afterT, false);
            }
        } else if (after instanceof ServiceSequenceEditPart) {
            return new ChangeTransactionOrderCommand(transaction, 0);
        }
        return null;
    }

    private Command moveServiceSequence(EditPart child, EditPart after) {
        ServiceSequence sequence = (ServiceSequence)child.getModel();
        if (after instanceof ServiceSequenceEditPart) {
            ServiceSequence afterS = (ServiceSequence)after.getModel();
            if (sequence.getService().equals(afterS.getService())) {
                return new ChangeServiceSequenceOrderCommand(sequence, afterS, false);
            }
        } else {
            if (after instanceof TransactionEditPart) {
                ServiceTransaction afterT = (ServiceTransaction)after;
                return new ChangeServiceSequenceOrderCommand(sequence, afterT.getServiceSequence(), false);
            }
            if (after instanceof AbstractPrimitiveEditPart) {
                Primitive afterP = (Primitive)after;
                return new ChangeServiceSequenceOrderCommand(sequence, afterP.getServiceTransaction().getServiceSequence(), false);
            }
            if (after == null && this.getHost().getModel() instanceof SimpleFBTypeImpl) {
                SimpleFBTypeImpl fb = (SimpleFBTypeImpl)this.getHost().getModel();
                int indexLastS = fb.getService().getServiceSequence().size() - 1;
                return new ChangeServiceSequenceOrderCommand(sequence, (ServiceSequence)fb.getService().getServiceSequence().get(indexLastS), false);
            }
        }
        return null;
    }
}

