/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.helpers.VarInOutHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.model.validation.LinkConstraints;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;

public class CreateSubAppCrossingConnectionsCommand
extends Command
implements ScopedCommand {
    private final IInterfaceElement source;
    private final IInterfaceElement destination;
    private final FBNetwork match;
    private final List<FBNetwork> sourceNetworks;
    private final List<FBNetwork> destinationNetworks;
    private final List<Command> commands = new ArrayList<Command>();

    protected CreateSubAppCrossingConnectionsCommand(IInterfaceElement source, IInterfaceElement destination, List<FBNetwork> sourceNetworks, List<FBNetwork> destinationNetworks, FBNetwork match) {
        this.source = Objects.requireNonNull(source);
        this.destination = Objects.requireNonNull(destination);
        this.sourceNetworks = Objects.requireNonNull(sourceNetworks);
        this.destinationNetworks = Objects.requireNonNull(destinationNetworks);
        this.match = Objects.requireNonNull(match);
    }

    public static Command createProcessBorderCrossingConnection(IInterfaceElement source, IInterfaceElement destination) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(destination);
        List<FBNetwork> sourceNetworks = CreateSubAppCrossingConnectionsCommand.buildHierarchy(source);
        List<FBNetwork> destinationNetworks = CreateSubAppCrossingConnectionsCommand.buildHierarchy(destination);
        FBNetwork match = CreateSubAppCrossingConnectionsCommand.findMostSpecificMatch(source, destination, sourceNetworks, destinationNetworks);
        if (CreateSubAppCrossingConnectionsCommand.isSwapNeeded(source, destination, sourceNetworks, destinationNetworks)) {
            return new CreateSubAppCrossingConnectionsCommand(destination, source, destinationNetworks, sourceNetworks, match);
        }
        return new CreateSubAppCrossingConnectionsCommand(source, destination, sourceNetworks, destinationNetworks, match);
    }

    public boolean canExecute() {
        if (!this.source.getClass().isAssignableFrom(this.destination.getClass()) && !this.destination.getClass().isAssignableFrom(this.source.getClass())) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_ConnectingIncompatibleInterfaceTypes);
            return false;
        }
        if (!LinkConstraints.isValidConnSource((IInterfaceElement)this.source, (FBNetwork)this.sourceNetworks.get(0)) || !LinkConstraints.isValidConnDestination((IInterfaceElement)this.destination, (FBNetwork)this.destinationNetworks.get(0))) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_STATUSMessage_IN_IN_OUT_OUT_notAllowed);
            return false;
        }
        if (this.source instanceof Event) {
            return true;
        }
        if (this.source instanceof VarDeclaration) {
            return this.dataConnectionChecks();
        }
        if (this.source instanceof AdapterDeclaration) {
            return this.adapterConnectionChecks();
        }
        return false;
    }

    public void execute() {
        IInterfaceElement leftTemplate = this.resolveTemplate(this.source, this.destination);
        IInterfaceElement rightTemplate = this.resolveTemplate(this.destination, this.source);
        IInterfaceElement left = this.buildPath(this.source, this.sourceNetworks, this.destination, false, leftTemplate);
        IInterfaceElement right = this.buildPath(this.destination, this.destinationNetworks, this.source, true, rightTemplate);
        this.createConnection(this.match, left, right);
    }

    private IInterfaceElement resolveTemplate(IInterfaceElement template, IInterfaceElement opposite) {
        VarDeclaration definingVar;
        VarDeclaration sourceVar;
        IInterfaceElement iInterfaceElement = this.source;
        if (iInterfaceElement instanceof VarDeclaration && (sourceVar = (VarDeclaration)iInterfaceElement).isInOutVar() && (definingVar = VarInOutHelper.getDefiningVarInOutDeclaration((VarDeclaration)sourceVar.getInOutVarOpposite())) != null) {
            return definingVar;
        }
        if ((IecTypes.GenericTypes.isAnyType((DataType)template.getType()) || EventTypeLibrary.isGenericEventType((DataType)template.getType())) && !IecTypes.GenericTypes.isAnyType((DataType)opposite.getType()) && !EventTypeLibrary.isGenericEventType((DataType)opposite.getType())) {
            return opposite;
        }
        return template;
    }

    private static boolean isSwapNeeded(IInterfaceElement source, IInterfaceElement destination, List<FBNetwork> sourceNetworks, List<FBNetwork> destinationNetworks) {
        boolean sourceIsInput = CreateSubAppCrossingConnectionsCommand.isInputElement(source, sourceNetworks);
        boolean destinationIsInput = CreateSubAppCrossingConnectionsCommand.isInputElement(destination, destinationNetworks);
        return sourceIsInput && !destinationIsInput;
    }

    private static boolean isInputElement(IInterfaceElement iel, List<FBNetwork> networkList) {
        BlockFBNetworkElement blockFBNetworkElement = iel.getBlockFBNetworkElement();
        if (blockFBNetworkElement instanceof SubApp) {
            SubApp subapp = (SubApp)blockFBNetworkElement;
            FBNetwork search = subapp.getSubAppNetwork();
            if (networkList.get(0) == search) {
                return !iel.isIsInput();
            }
        }
        return iel.isIsInput();
    }

    private static FBNetwork findMostSpecificMatch(IInterfaceElement source, IInterfaceElement destination, List<FBNetwork> sourceNetworks, List<FBNetwork> destinationNetworks) {
        FBNetwork sourceSubAppNetwork = CreateSubAppCrossingConnectionsCommand.addSubAppNetworkToList(source, sourceNetworks);
        FBNetwork destSubAppNetwork = CreateSubAppCrossingConnectionsCommand.addSubAppNetworkToList(destination, destinationNetworks);
        int sourceIndex = sourceNetworks.size() - 1;
        int destinationIndex = destinationNetworks.size() - 1;
        FBNetwork match = sourceNetworks.get(0);
        while (sourceIndex >= 0 && destinationIndex >= 0 && sourceNetworks.get(sourceIndex) == destinationNetworks.get(destinationIndex)) {
            match = sourceNetworks.get(sourceIndex);
            --sourceIndex;
            --destinationIndex;
        }
        CreateSubAppCrossingConnectionsCommand.checkIfSubAppNetworkIsNeeded(sourceNetworks, sourceSubAppNetwork, match);
        CreateSubAppCrossingConnectionsCommand.checkIfSubAppNetworkIsNeeded(destinationNetworks, destSubAppNetwork, match);
        return match;
    }

    private static FBNetwork addSubAppNetworkToList(IInterfaceElement ie, List<FBNetwork> networkList) {
        SubApp subApp;
        FBNetwork subAppNetwork = null;
        BlockFBNetworkElement blockFBNetworkElement = ie.getBlockFBNetworkElement();
        if (blockFBNetworkElement instanceof SubApp && !(subApp = (SubApp)blockFBNetworkElement).isTyped()) {
            subAppNetwork = subApp.getSubAppNetwork();
            networkList.add(0, subAppNetwork);
        }
        return subAppNetwork;
    }

    private static void checkIfSubAppNetworkIsNeeded(List<FBNetwork> networkList, FBNetwork addedSubappNetwork, FBNetwork match) {
        if (addedSubappNetwork != null && match != networkList.get(0)) {
            networkList.remove(addedSubappNetwork);
        }
    }

    private static List<FBNetwork> buildHierarchy(IInterfaceElement source) {
        ArrayList<FBNetwork> list = new ArrayList<FBNetwork>();
        EObject current = source.eContainer();
        while (current != null) {
            if (current instanceof FBNetwork) {
                FBNetwork currentFbNetwork = (FBNetwork)current;
                list.add(currentFbNetwork);
            }
            if (current instanceof SubAppType) {
                SubAppType satype = (SubAppType)current;
                list.add(satype.getFBNetwork());
            }
            current = current.eContainer();
        }
        return list;
    }

    private IInterfaceElement buildPath(IInterfaceElement element, List<FBNetwork> networks, IInterfaceElement oppositePin, boolean isRightPath, IInterfaceElement template) {
        IInterfaceElement ie = element;
        FBNetwork network = networks.get(0);
        int i = 0;
        while (network != this.match) {
            SubApp subapp = (SubApp)network.eContainer();
            IInterfaceElement existingConnection = this.existingConnection(ie, subapp, oppositePin, isRightPath);
            if (existingConnection != null) {
                ie = existingConnection;
            } else {
                IInterfaceElement createdPin = this.createInterfaceElement(isRightPath, ie, subapp, template);
                if (isRightPath) {
                    this.createConnection(network, createdPin, ie);
                } else {
                    this.createConnection(network, ie, createdPin);
                }
                ie = createdPin;
            }
            network = networks.get(++i);
        }
        return ie;
    }

    private IInterfaceElement existingConnection(IInterfaceElement ie, SubApp subapp, IInterfaceElement oppositePin, boolean isRightPath) {
        if (isRightPath) {
            Optional<Connection> connection = ie.getInputConnections().stream().filter(con -> con.getSourceElement().equals(subapp) && CreateSubAppCrossingConnectionsCommand.compatibleTypes(ie, con.getSource())).findFirst();
            if (connection.isPresent()) {
                return connection.get().getSource();
            }
        } else {
            Optional<Connection> connection = ie.getOutputConnections().stream().filter(con -> con.getDestinationElement().equals(subapp) && CreateSubAppCrossingConnectionsCommand.compatibleTypes(ie, con.getDestination())).findFirst();
            if (connection.isPresent()) {
                return connection.get().getDestination();
            }
        }
        return this.existingSubAppPin(ie, oppositePin, isRightPath);
    }

    IInterfaceElement existingSubAppPin(IInterfaceElement ie, IInterfaceElement oppositePin, boolean isRightPath) {
        FBNetworkElement fBNetworkElement;
        if (isRightPath) {
            FBNetworkElement fBNetworkElement2;
            if (ie.getBlockFBNetworkElement() != null && (fBNetworkElement2 = ie.getBlockFBNetworkElement().getOuterFBNetworkElement()) instanceof BlockFBNetworkElement) {
                VarDeclaration varDecl;
                BlockFBNetworkElement outerFB = (BlockFBNetworkElement)fBNetworkElement2;
                Optional<IInterfaceElement> subappPin = ie instanceof Event ? outerFB.getInterface().getEventInputs().stream().filter(pin -> this.isSourceTypeMatching(ie, (IInterfaceElement)pin, oppositePin, isRightPath)).findFirst().map(IInterfaceElement.class::cast) : (ie instanceof VarDeclaration && (varDecl = (VarDeclaration)ie).isInOutVar() ? outerFB.getInterface().getInOutVars().stream().filter(pin -> this.isSourceTypeMatching(ie, (IInterfaceElement)pin, oppositePin, isRightPath)).findFirst().map(IInterfaceElement.class::cast) : outerFB.getInterface().getInputVars().stream().filter(pin -> this.isSourceTypeMatching(ie, (IInterfaceElement)pin, oppositePin, isRightPath)).findFirst().map(IInterfaceElement.class::cast));
                if (subappPin.isPresent()) {
                    this.createConnection(ie.getBlockFBNetworkElement().getFbNetwork(), subappPin.get(), ie);
                    return subappPin.get();
                }
            }
        } else if (ie.getBlockFBNetworkElement() != null && (fBNetworkElement = ie.getBlockFBNetworkElement().getOuterFBNetworkElement()) instanceof BlockFBNetworkElement) {
            VarDeclaration varDecl;
            BlockFBNetworkElement outerFB = (BlockFBNetworkElement)fBNetworkElement;
            Optional<IInterfaceElement> subappPin = ie instanceof Event ? outerFB.getInterface().getEventOutputs().stream().filter(pin -> this.isSourceTypeMatching(ie, (IInterfaceElement)pin, oppositePin, isRightPath)).findFirst().map(IInterfaceElement.class::cast) : (ie instanceof VarDeclaration && (varDecl = (VarDeclaration)ie).isInOutVar() ? outerFB.getInterface().getOutMappedInOutVars().stream().filter(pin -> this.isSourceTypeMatching(ie, (IInterfaceElement)pin, oppositePin, isRightPath)).findFirst().map(IInterfaceElement.class::cast) : outerFB.getInterface().getOutputVars().stream().filter(pin -> this.isSourceTypeMatching(ie, (IInterfaceElement)pin, oppositePin, isRightPath)).findFirst().map(IInterfaceElement.class::cast));
            if (subappPin.isPresent()) {
                this.createConnection(ie.getBlockFBNetworkElement().getFbNetwork(), subappPin.get(), ie);
                return subappPin.get();
            }
        }
        return null;
    }

    boolean isSourceTypeMatching(IInterfaceElement ie, IInterfaceElement subAppPin, IInterfaceElement oppositePin, boolean isRightPath) {
        if (isRightPath) {
            return !subAppPin.getInputConnections().stream().filter(p -> this.getConnectionSourceFBInterfaceElements((Connection)p, isRightPath).contains(oppositePin)).findAny().isEmpty();
        }
        return !subAppPin.getOutputConnections().stream().filter(p -> this.getConnectionSourceFBInterfaceElements((Connection)p, isRightPath).contains(oppositePin)).findAny().isEmpty();
    }

    List<IInterfaceElement> getConnectionSourceFBInterfaceElements(Connection con, boolean isRightPath) {
        ArrayList<IInterfaceElement> list = new ArrayList<IInterfaceElement>();
        if (isRightPath) {
            if (!(con.getSourceElement() instanceof FB)) {
                con.getSource().getInputConnections().forEach(s -> {
                    boolean bl2 = list.addAll(this.getConnectionSourceFBInterfaceElements((Connection)s, isRightPath));
                });
                return list;
            }
            list.add(con.getSource());
            return list;
        }
        if (!(con.getSourceElement() instanceof FB)) {
            con.getDestination().getOutputConnections().forEach(s -> {
                boolean bl2 = list.addAll(this.getConnectionSourceFBInterfaceElements((Connection)s, isRightPath));
            });
            return list;
        }
        list.add(con.getDestination());
        return list;
    }

    private IInterfaceElement createInterfaceElement(boolean isRightPath, IInterfaceElement ie, SubApp subapp, IInterfaceElement template) {
        VarDeclaration templateVar;
        if (this.emptyPinAlreadyExists(subapp, ie, isRightPath)) {
            return subapp.getInterface().getInterfaceElement(ie);
        }
        boolean isInOut = template instanceof VarDeclaration && (templateVar = (VarDeclaration)template).isInOutVar();
        CreateSubAppInterfaceElementCommand pinCmd = new CreateSubAppInterfaceElementCommand(template.getType(), this.source.getName(), subapp.getInterface(), isRightPath, isInOut, ArraySizeHelper.getArraySize((IInterfaceElement)template), -1);
        pinCmd.execute();
        this.commands.add((Command)pinCmd);
        return pinCmd.getCreatedElement();
    }

    private boolean emptyPinAlreadyExists(SubApp subapp, IInterfaceElement ie, boolean isRightPath) {
        IInterfaceElement pin = subapp.getInterface().getInterfaceElement(ie);
        if (pin != null && pin.getInputConnections().isEmpty() && pin.getOutputConnections().isEmpty() && this.compatibleTypes(pin)) {
            return pin.isIsInput() && isRightPath || !pin.isIsInput() && !isRightPath;
        }
        return false;
    }

    private boolean compatibleTypes(IInterfaceElement pin) {
        return CreateSubAppCrossingConnectionsCommand.compatibleTypes(this.source, pin);
    }

    private static boolean compatibleTypes(IInterfaceElement pin1, IInterfaceElement pin2) {
        if (pin1.getType() == null || pin2.getType() == null) {
            return false;
        }
        return LinkConstraints.typeCheck((IInterfaceElement)pin1, (IInterfaceElement)pin2);
    }

    private void createConnection(FBNetwork network, IInterfaceElement connSource, IInterfaceElement connDestination) {
        AbstractConnectionCreateCommand connCmd = AbstractConnectionCreateCommand.createCommand((FBNetwork)network, (IInterfaceElement)connSource, (IInterfaceElement)connDestination);
        connCmd.setSource(connSource);
        connCmd.setDestination(connDestination);
        connCmd.setVisible(CreateSubAppCrossingConnectionsCommand.connShouldBeVisible(network, connSource, connDestination));
        if (connCmd.canExecute()) {
            connCmd.execute();
            this.commands.add((Command)connCmd);
        }
    }

    public void undo() {
        ListIterator<Command> iterator = this.commands.listIterator(this.commands.size());
        while (iterator.hasPrevious()) {
            iterator.previous().undo();
        }
    }

    public void redo() {
        this.commands.forEach(Command::redo);
    }

    private boolean dataConnectionChecks() {
        VarDeclaration sourceData;
        IInterfaceElement iInterfaceElement;
        VarDeclaration targetData;
        if (!LinkConstraints.hasAlreadyInputConnectionsCheck((IInterfaceElement)this.source, (IInterfaceElement)this.destination, null)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyInputConnection, this.destination.getName()));
            return false;
        }
        if (!(this.source.getType() instanceof StructuredType && this.destination.getType() instanceof StructuredType || LinkConstraints.typeCheck((IInterfaceElement)this.source, (IInterfaceElement)this.destination))) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_NotCompatible, this.source.getType() != null ? this.source.getType().getName() : FordiacMessages.NA, this.destination.getType() != null ? this.destination.getType().getName() : FordiacMessages.NA));
            return false;
        }
        IInterfaceElement iInterfaceElement2 = this.destination;
        if (iInterfaceElement2 instanceof VarDeclaration && (targetData = (VarDeclaration)iInterfaceElement2).isInOutVar() && (iInterfaceElement = this.source) instanceof VarDeclaration && !(sourceData = (VarDeclaration)iInterfaceElement).isInOutVar()) {
            ErrorMessenger.popUpErrorMessage((String)Messages.ConnectionValidator_OutputsCannotBeConnectedToVarInOuts);
            return false;
        }
        return LinkConstraints.isWithConstraintOK((IInterfaceElement)this.source) && LinkConstraints.isWithConstraintOK((IInterfaceElement)this.destination);
    }

    private boolean adapterConnectionChecks() {
        if (!LinkConstraints.hasAlreadyInputConnectionsCheck((IInterfaceElement)this.source, (IInterfaceElement)this.destination, null)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyInputConnection, this.destination.getName()));
            return false;
        }
        if (LinkConstraints.hasAlreadyOutputConnectionsCheck((IInterfaceElement)this.source, null)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyOutputConnection, this.source.getName()));
            return false;
        }
        if (!LinkConstraints.adapaterTypeCompatibilityCheck((IInterfaceElement)this.source, (IInterfaceElement)this.destination)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_NotCompatible, this.source.getType() != null ? this.source.getType().getName() : FordiacMessages.ND, this.destination.getType() != null ? this.destination.getType().getName() : FordiacMessages.ND));
            return false;
        }
        return true;
    }

    public Set<EObject> getAffectedObjects() {
        Set<ScopedCommand> scopedCommands = this.commands.stream().filter(ScopedCommand.class::isInstance).map(c -> (ScopedCommand)c).collect(Collectors.toSet());
        HashSet<EObject> se = new HashSet<EObject>();
        scopedCommands.forEach(c -> {
            boolean bl = se.addAll(c.getAffectedObjects());
        });
        return se;
    }

    private static boolean connShouldBeVisible(FBNetwork parentNW, IInterfaceElement src, IInterfaceElement dst) {
        SubApp dstSubapp;
        boolean dstHidden;
        SubApp srcSubapp;
        BlockFBNetworkElement blockFBNetworkElement = src.getBlockFBNetworkElement();
        boolean srcHidden = blockFBNetworkElement instanceof SubApp && (srcSubapp = (SubApp)blockFBNetworkElement).isUnfolded() && parentNW == srcSubapp.getFbNetwork();
        BlockFBNetworkElement blockFBNetworkElement2 = dst.getBlockFBNetworkElement();
        boolean bl = dstHidden = blockFBNetworkElement2 instanceof SubApp && (dstSubapp = (SubApp)blockFBNetworkElement2).isUnfolded() && parentNW == dstSubapp.getFbNetwork();
        return !srcHidden && !dstHidden;
    }
}

