/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.application.actions.CopyPasteData;
import org.eclipse.fordiac.ide.application.commands.ConnectionReference;
import org.eclipse.fordiac.ide.application.commands.MoveAndReconnectCommand;
import org.eclipse.fordiac.ide.application.commands.PasteCommand;
import org.eclipse.fordiac.ide.application.editparts.EditorWithInterfaceEditPart;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.policies.ContainerResizePolicy;
import org.eclipse.fordiac.ide.application.policies.FBNetworkElementNonResizeableEP;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.ModifiedResizeablePolicy;
import org.eclipse.fordiac.ide.gef.utilities.RequestUtil;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeContainerBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.FBNetworkElementSetPositionCommand;
import org.eclipse.fordiac.ide.model.commands.change.RemoveElementsFromGroup;
import org.eclipse.fordiac.ide.model.commands.change.SetPositionCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class FBNetworkXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        SubApp subApp;
        Object model = child.getModel();
        if (model instanceof Group || model instanceof SubApp && (subApp = (SubApp)model).isUnfolded()) {
            return new ContainerResizePolicy();
        }
        if (model instanceof Comment) {
            return new ModifiedResizeablePolicy();
        }
        if (model instanceof FBNetworkElement) {
            return new FBNetworkElementNonResizeableEP();
        }
        return new ModifiedNonResizeableEditPolicy();
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if ((child.getModel() instanceof Group || child.getModel() instanceof SubApp || child.getModel() instanceof Comment) && RequestUtil.isResizeRequest((Request)request)) {
            return FBNetworkXYLayoutEditPolicy.createChangeSizeCommand((GraphicalEditPart)child, (Rectangle)constraint, request);
        }
        Object object = child.getModel();
        if (object instanceof PositionableElement) {
            PositionableElement pe = (PositionableElement)object;
            if (RequestUtil.isMoveRequest((Request)request)) {
                return FBNetworkXYLayoutEditPolicy.createMoveCommand(pe, (Rectangle)constraint);
            }
        }
        return null;
    }

    private static Command createChangeSizeCommand(GraphicalEditPart child, Rectangle constraint, ChangeBoundsRequest request) {
        FBNetworkElement fbnEl = (FBNetworkElement)child.getModel();
        Rectangle origBounds = child.getFigure().getBounds();
        if (constraint.width == origBounds.width && constraint.height == origBounds.height) {
            return FBNetworkXYLayoutEditPolicy.createMoveCommand((PositionableElement)fbnEl, constraint);
        }
        if (request.getMoveDelta().x == 0 && request.getSizeDelta().width != 0) {
            --constraint.width;
        }
        if (request.getMoveDelta().y == 0 && request.getSizeDelta().height != 0) {
            --constraint.height;
        }
        return FBNetworkXYLayoutEditPolicy.createChangeBoundsCommand(fbnEl, constraint);
    }

    public static AbstractChangeContainerBoundsCommand createChangeBoundsCommand(FBNetworkElement container, Rectangle constraint) {
        Position newPos = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(constraint.x, constraint.y);
        double newWidth = CoordinateConverter.INSTANCE.screenToIEC61499(constraint.width);
        double newHeight = CoordinateConverter.INSTANCE.screenToIEC61499(constraint.height);
        return AbstractChangeContainerBoundsCommand.getCommandFor((FBNetworkElement)container, (Position)newPos, (double)newWidth, (double)newHeight);
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (request != null) {
            Object childClass = request.getNewObjectType();
            Point insertPoint = this.getInsertPoint(request);
            FBNetwork fbNetwork = this.getFBNetwork();
            if (fbNetwork != null && childClass instanceof TypeEntry) {
                TypeEntry typeEntry = (TypeEntry)childClass;
                return AbstractCreateFBNetworkElementCommand.createCreateCommand((TypeEntry)typeEntry, (FBNetwork)fbNetwork, (int)insertPoint.x, (int)insertPoint.y);
            }
        }
        return null;
    }

    protected Point getInsertPoint(CreateRequest request) {
        Point insertPoint = ((Rectangle)this.getConstraintFor(request)).getTopLeft();
        SnapToHelper helper = (SnapToHelper)this.getHost().getAdapter(SnapToHelper.class);
        if (helper != null) {
            this.getHost().getFigure().translateToAbsolute((Translatable)insertPoint);
            PrecisionPoint preciseLocation = new PrecisionPoint(insertPoint);
            PrecisionPoint result = new PrecisionPoint(insertPoint);
            helper.snapPoint(null, 192, preciseLocation, result);
            this.getHost().getFigure().translateToRelative((Translatable)result);
            return result;
        }
        return insertPoint;
    }

    protected Command getAddCommand(Request request) {
        if (FBNetworkXYLayoutEditPolicy.isDragAndDropRequestToRoot(request, this.getTargetEditPart(request))) {
            return this.handleDragToRootRequest((ChangeBoundsRequest)request);
        }
        return null;
    }

    protected ZoomManager getZoomManager() {
        return ((ScalableFreeformRootEditPart)this.getHost().getRoot()).getZoomManager();
    }

    private Command handleDragToRootRequest(ChangeBoundsRequest request) {
        List editParts = request.getEditParts();
        Point destination = this.getTranslatedAndZoomedPoint(request);
        List<FBNetworkElement> fbEls = FBNetworkXYLayoutEditPolicy.collectDraggedFBs(editParts, this.getFBNetwork());
        if (!fbEls.isEmpty()) {
            return new MoveAndReconnectCommand(fbEls, destination, (FBNetwork)this.getHost().getModel());
        }
        GroupContentEditPart groupContent = FBNetworkXYLayoutEditPolicy.getGroupContentEditPart(editParts);
        if (groupContent != null) {
            return this.createRemoveFromGroup(groupContent, request);
        }
        return this.createSplitEditorMoveCommand(request);
    }

    private Command createRemoveFromGroup(GroupContentEditPart groupContent, ChangeBoundsRequest request) {
        List<FBNetworkElement> fbEls = FBNetworkXYLayoutEditPolicy.collectFromGroupDraggedFBs(request.getEditParts());
        if (!fbEls.isEmpty()) {
            Point topLeft = groupContent.getFigure().getBounds().getTopLeft();
            Point moveDelta = this.getScaledMoveDelta(request);
            topLeft.translate(moveDelta.x, moveDelta.y);
            return new RemoveElementsFromGroup(fbEls, topLeft);
        }
        return null;
    }

    private Command createSplitEditorMoveCommand(ChangeBoundsRequest request) {
        List<FBNetworkElement> movedElements = request.getEditParts().stream().filter(ep -> {
            FBNetworkElement fbnel;
            Object object = ep.getModel();
            return object instanceof FBNetworkElement && (fbnel = (FBNetworkElement)object).eContainer() == this.getFBNetwork();
        }).map(ep -> (FBNetworkElement)ep.getModel()).toList();
        if (movedElements.isEmpty()) {
            return null;
        }
        Position topLeftCornerOfFBNetwork = FBNetworkHelper.getTopLeftCornerOfFBNetwork(movedElements);
        Point targetPos = this.getTranslatedAndZoomedPoint(request);
        Position iec61499TargetPos = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(targetPos.x, targetPos.y);
        CompoundCommand cmd = new CompoundCommand();
        movedElements.forEach(fbnEl -> {
            Position newPos = LibraryElementFactory.eINSTANCE.createPosition();
            newPos.setX(iec61499TargetPos.getX() + fbnEl.getPosition().getX() - topLeftCornerOfFBNetwork.getX());
            newPos.setY(iec61499TargetPos.getY() + fbnEl.getPosition().getY() - topLeftCornerOfFBNetwork.getY());
            cmd.add((Command)new FBNetworkElementSetPositionCommand(fbnEl, newPos));
        });
        return cmd;
    }

    protected Point getTranslatedAndZoomedPoint(ChangeBoundsRequest request) {
        Point location = request.getLocation().getCopy();
        this.getHost().getFigure().translateToRelative((Translatable)location);
        return location;
    }

    private static List<FBNetworkElement> collectDraggedFBs(List<? extends EditPart> editParts, FBNetwork fbNetwork) {
        return editParts.stream().filter(ep -> ep.getModel() instanceof FBNetworkElement).map(ep -> (FBNetworkElement)ep.getModel()).filter(el -> !el.getFbNetwork().equals(fbNetwork)).toList();
    }

    private static GroupContentEditPart getGroupContentEditPart(List<? extends EditPart> editParts) {
        return editParts.stream().filter(ep -> ep.getParent() instanceof GroupContentEditPart).map(EditPart::getParent).findFirst().orElse(null);
    }

    private static List<FBNetworkElement> collectFromGroupDraggedFBs(List<? extends EditPart> editParts) {
        return editParts.stream().filter(ep -> ep.getParent() instanceof GroupContentEditPart).map(ep -> (FBNetworkElement)ep.getModel()).toList();
    }

    protected Command getCloneCommand(ChangeBoundsRequest request) {
        CopyPasteData copyPasteData = new CopyPasteData(this.getFBNetwork());
        PrecisionRectangle originalBounds = null;
        for (EditPart ep : request.getEditParts()) {
            Object object;
            Objects.requireNonNull(ep.getModel());
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FBNetworkElement.class, Connection.class}, (Object)object, 0)) {
                case 0: {
                    FBNetworkElement el = (FBNetworkElement)object;
                    copyPasteData.elements().add(el);
                    IFigure fig = ((GraphicalEditPart)ep).getFigure();
                    PrecisionRectangle bounds = new PrecisionRectangle(fig.getBounds());
                    fig.translateToAbsolute((Translatable)bounds);
                    if (originalBounds == null) {
                        originalBounds = bounds;
                        break;
                    }
                    originalBounds.union((Rectangle)bounds);
                    break;
                }
                case 1: {
                    Connection conn = (Connection)object;
                    copyPasteData.conns().add(new ConnectionReference(conn));
                    break;
                }
            }
        }
        Rectangle targetBounds = request.getTransformedRectangle(originalBounds);
        this.translateFromAbsoluteToLayoutRelative((Translatable)targetBounds);
        return new PasteCommand(copyPasteData, this.getFBNetwork(), new org.eclipse.swt.graphics.Point(targetBounds.x, targetBounds.y));
    }

    public static boolean isDragAndDropRequestToRoot(Request generic, EditPart targetEditPart) {
        return generic instanceof ChangeBoundsRequest && (targetEditPart instanceof FBNetworkEditPart || targetEditPart instanceof EditorWithInterfaceEditPart) && !(targetEditPart instanceof UnfoldedSubappContentEditPart) && !(targetEditPart instanceof GroupContentEditPart);
    }

    private FBNetwork getFBNetwork() {
        FBNetwork fbNetwork;
        Object object = this.getHost().getModel();
        return object instanceof FBNetwork ? (fbNetwork = (FBNetwork)object) : null;
    }

    private static Command createMoveCommand(PositionableElement model, Rectangle constraint) {
        Position newPos = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(constraint.x, constraint.y);
        if (model instanceof FBNetworkElement) {
            FBNetworkElement fbnEl = (FBNetworkElement)model;
            return new FBNetworkElementSetPositionCommand(fbnEl, newPos);
        }
        return new SetPositionCommand(model, newPos);
    }

    protected Point getScaledMoveDelta(ChangeBoundsRequest request) {
        Point moveDelta = request.getMoveDelta().getCopy();
        this.getHost().getFigure().translateToRelative((Translatable)moveDelta);
        return moveDelta;
    }
}

