/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal.direction;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.NorthToSouthRoutingStrategy;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.RoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.SouthToNorthRoutingStrategy;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.WestToEastRoutingStrategy;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortSide;

public abstract class BaseRoutingDirectionStrategy {
    private final Set<KVector> createdJunctionPoints = Sets.newHashSet();

    public static BaseRoutingDirectionStrategy forRoutingDirection(RoutingDirection direction) {
        switch (direction) {
            case WEST_TO_EAST: {
                return new WestToEastRoutingStrategy();
            }
            case NORTH_TO_SOUTH: {
                return new NorthToSouthRoutingStrategy();
            }
            case SOUTH_TO_NORTH: {
                return new SouthToNorthRoutingStrategy();
            }
        }
        throw new IllegalArgumentException();
    }

    protected void addJunctionPointIfNecessary(LEdge edge, HyperEdgeSegment segment, KVector pos, boolean vertical) {
        double p;
        double d = p = vertical ? pos.y : pos.x;
        if (this.createdJunctionPoints.contains(pos)) {
            return;
        }
        boolean pointInsideEdgeSegment = p > segment.getStartCoordinate() && p < segment.getEndCoordinate();
        boolean pointAtSegmentBoundary = false;
        if (!segment.getIncomingConnectionCoordinates().isEmpty() && !segment.getOutgoingConnectionCoordinates().isEmpty()) {
            pointAtSegmentBoundary |= Math.abs(p - segment.getIncomingConnectionCoordinates().getFirst()) < 0.001 && Math.abs(p - segment.getOutgoingConnectionCoordinates().getFirst()) < 0.001;
            pointAtSegmentBoundary |= Math.abs(p - segment.getIncomingConnectionCoordinates().getLast()) < 0.001 && Math.abs(p - segment.getOutgoingConnectionCoordinates().getLast()) < 0.001;
        }
        if (pointInsideEdgeSegment || pointAtSegmentBoundary) {
            KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayeredOptions.JUNCTION_POINTS);
            if (junctionPoints == null) {
                junctionPoints = new KVectorChain();
                edge.setProperty(LayeredOptions.JUNCTION_POINTS, junctionPoints);
            }
            KVector jpoint = new KVector(pos);
            junctionPoints.add((Object)jpoint);
            this.createdJunctionPoints.add(jpoint);
        }
    }

    public Set<KVector> getCreatedJunctionPoints() {
        return this.createdJunctionPoints;
    }

    public void clearCreatedJunctionPoints() {
        this.createdJunctionPoints.clear();
    }

    public abstract double getPortPositionOnHyperNode(LPort var1);

    public abstract PortSide getSourcePortSide();

    public abstract PortSide getTargetPortSide();

    public abstract void calculateBendPoints(HyperEdgeSegment var1, double var2, double var4);
}

