/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.ui.editors.SubEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class SubEditorInputFactory
implements IElementFactory {
    public static final String ID = "org.eclipse.fordiac.ide.model.ui.editors.SubEditorInputFactory";
    private static final String TAG_EDITOR_INPUT = "editorInput";
    private static final String TAG_FACTORY_ID = "factoryID";
    private static final String TAG_ELEMENT_CLASS = "elementClass";
    private static final String TAG_FRAGMENT = "fragment";

    /*
     * WARNING - void declaration
     */
    public IAdaptable createElement(IMemento memento) {
        void editorInput;
        String factoryId = memento.getString(TAG_FACTORY_ID);
        if (factoryId == null) {
            return null;
        }
        IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryId);
        if (factory == null) {
            return null;
        }
        IMemento editorInputChild = memento.getChild(TAG_EDITOR_INPUT);
        if (editorInputChild == null) {
            return null;
        }
        IAdaptable adaptable = factory.createElement(editorInputChild);
        if (!(adaptable instanceof IEditorInput)) {
            return null;
        }
        IEditorInput iEditorInput = (IEditorInput)adaptable;
        String fragment = memento.getString(TAG_FRAGMENT);
        if (fragment == null) {
            return null;
        }
        EClass elementClass = SubEditorInputFactory.getElementClass(memento);
        if (elementClass == null) {
            return null;
        }
        return new SubEditorInput((IEditorInput)editorInput, elementClass, fragment);
    }

    public static void saveState(IMemento memento, SubEditorInput input) {
        IPersistableElement persistable = input.getParent().getPersistable();
        persistable.saveState(memento.createChild(TAG_EDITOR_INPUT));
        memento.putString(TAG_FACTORY_ID, persistable.getFactoryId());
        memento.putString(TAG_ELEMENT_CLASS, EcoreUtil.getURI((EObject)input.getElementClass()).toString());
        memento.putString(TAG_FRAGMENT, input.getFragment());
    }

    private static EClass getElementClass(IMemento memento) {
        Resource eResource;
        URI elementClassURI;
        EPackage ePackage;
        String elementClassString = memento.getString(TAG_ELEMENT_CLASS);
        if (elementClassString != null && (ePackage = EPackage.Registry.INSTANCE.getEPackage((elementClassURI = URI.createURI((String)elementClassString)).trimFragment().toString())) != null && (eResource = ePackage.eResource()) != null) {
            return (EClass)eResource.getEObject(elementClassURI.fragment());
        }
        return null;
    }
}

