/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IScalablePane;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ScalableFreeformLayeredPane
extends FreeformLayeredPane
implements IScalablePane {
    private double scale = 1.0;
    private final boolean useScaledGraphics;

    public ScalableFreeformLayeredPane() {
        this(true);
    }

    public ScalableFreeformLayeredPane(boolean useScaledGraphics) {
        this.useScaledGraphics = useScaledGraphics;
    }

    @Override
    public Rectangle getClientArea(Rectangle rect) {
        return IScalablePane.IScalablePaneHelper.getClientArea(this, rectangle -> super.getClientArea((Rectangle)rectangle), rect);
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public boolean isCoordinateSystem() {
        return true;
    }

    @Override
    protected void paintClientArea(Graphics graphics2) {
        IScalablePane.IScalablePaneHelper.paintClientArea(this, graphics -> super.paintClientArea((Graphics)graphics), graphics2);
    }

    @Override
    public boolean optimizeClip() {
        return super.optimizeClip();
    }

    @Override
    public void setScale(double newZoom) {
        if (this.scale == newZoom) {
            return;
        }
        this.scale = newZoom;
        this.superFireMoved();
        this.getFreeformHelper().invalidate();
        this.repaint();
    }

    @Override
    public boolean useScaledGraphics() {
        return this.useScaledGraphics;
    }

    @Override
    public void translateToParent(Translatable t) {
        IScalablePane.IScalablePaneHelper.translateToParent(this, t);
    }

    @Override
    public void translateFromParent(Translatable t) {
        IScalablePane.IScalablePaneHelper.translateFromParent(this, t);
    }
}

