/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.GroupOrderStrategy;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p1cycles.GroupModelOrderCalculator;
import org.eclipse.elk.alg.layered.p1cycles.SCCModelOrderCycleBreaker;

public class SCConnectivity
extends SCCModelOrderCycleBreaker {
    @Override
    public void findNodes(int offset, int bigOffset) {
        int i = 0;
        while (i < this.stronglyConnectedComponents.size()) {
            if (((Set)this.stronglyConnectedComponents.get(i)).size() > 1) {
                LNode min = null;
                LNode max = null;
                int modelOrderMin = Integer.MAX_VALUE;
                int modelOrderMax = Integer.MIN_VALUE;
                boolean enforceGroupModelOrder = this.graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CB_GROUP_ORDER_STRATEGY) == GroupOrderStrategy.ENFORCED;
                GroupModelOrderCalculator calculator = new GroupModelOrderCalculator();
                for (LNode n : (Set)this.stronglyConnectedComponents.get(i)) {
                    int modelOrderCurrent;
                    if (min == null || max == null) {
                        min = n;
                        modelOrderMin = enforceGroupModelOrder ? calculator.computeConstraintGroupModelOrder(n, bigOffset, offset) : calculator.computeConstraintModelOrder(n, offset);
                        max = n;
                        modelOrderMax = modelOrderMin;
                        continue;
                    }
                    int n2 = modelOrderCurrent = enforceGroupModelOrder ? calculator.computeConstraintGroupModelOrder(n, bigOffset, offset) : calculator.computeConstraintModelOrder(n, offset);
                    if (modelOrderMin > modelOrderCurrent) {
                        min = n;
                        modelOrderMin = modelOrderCurrent;
                    }
                    if (modelOrderMax >= modelOrderCurrent) continue;
                    max = n;
                    modelOrderMax = modelOrderCurrent;
                }
                if (Iterables.size(min.getIncomingEdges()) > Iterables.size(max.getOutgoingEdges())) {
                    for (LEdge edge : min.getIncomingEdges()) {
                        if (!((Set)this.stronglyConnectedComponents.get(i)).contains((Object)edge.getSource().getNode())) continue;
                        this.revEdges.add(edge);
                    }
                } else {
                    for (LEdge edge : max.getOutgoingEdges()) {
                        if (!((Set)this.stronglyConnectedComponents.get(i)).contains((Object)edge.getTarget().getNode())) continue;
                        this.revEdges.add(edge);
                    }
                }
            }
            ++i;
        }
    }
}

