/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.commands.ConvertGroupToSubappCommand;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.fordiac.ide.application.policies.FBNetworkXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeContainerBoundsCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertToSubappHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Group group = ConvertToSubappHandler.getSelectedGroup(selection);
        if (group != null) {
            CommandStack commandStack = HandlerHelper.getCommandStack((IEditorPart)editor);
            ConvertGroupToSubappCommand conversion = new ConvertGroupToSubappCommand(group);
            if (conversion.canExecute()) {
                commandStack.execute((Command)conversion);
                ConvertToSubappHandler.refreshSelection(conversion.getCreatedElement());
                GraphicalViewer v = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
                v.flush();
                EditPart newSubappEP = v.getEditPartForModel((Object)conversion.getCreatedElement());
                ConvertToSubappHandler.adjustMinBounds(commandStack, newSubappEP);
            }
        }
        return Status.OK_STATUS;
    }

    private static void adjustMinBounds(CommandStack cmdStack, EditPart subappEP) {
        IContainerEditPart containerEditPart = (IContainerEditPart)subappEP;
        GraphicalEditPart contentEP = containerEditPart.getContentEP();
        Rectangle subappContentBounds = containerEditPart.getMinContentBounds();
        subappContentBounds.setWidth(Math.max(subappContentBounds.width, contentEP.getFigure().getSize().width));
        subappContentBounds.setHeight(Math.max(subappContentBounds.height, contentEP.getFigure().getSize().height));
        AbstractChangeContainerBoundsCommand cmd = FBNetworkXYLayoutEditPolicy.createChangeBoundsCommand((FBNetworkElement)containerEditPart.getModel(), subappContentBounds);
        if (cmd.canExecute()) {
            cmdStack.execute((Command)cmd);
        }
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        Group group = ConvertToSubappHandler.getSelectedGroup(selection);
        this.setBaseEnabled(group != null && !group.isContainedInTypedInstance());
    }

    private static Group getSelectedGroup(Object selection) {
        IStructuredSelection structSel;
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty() && structSel.size() == 1) {
            return ConvertToSubappHandler.getGroup(structSel.getFirstElement());
        }
        return null;
    }

    private static Group getGroup(Object currentElement) {
        Object elementToCheck = currentElement;
        if (elementToCheck instanceof EditPart) {
            EditPart ep = (EditPart)elementToCheck;
            elementToCheck = ep.getModel();
        }
        if (elementToCheck instanceof Group) {
            Group group = (Group)elementToCheck;
            return group;
        }
        return null;
    }

    private static void refreshSelection(SubApp subapp) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        HandlerHelper.getViewer((IEditorPart)editor).deselectAll();
        HandlerHelper.selectElement((Object)subapp, (GraphicalViewer)HandlerHelper.getViewer((IEditorPart)editor));
    }
}

