/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.handler;

import java.util.List;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.deployment.debug.ui.handler.AbstractDeviceDeploymentCommand;
import org.eclipse.fordiac.ide.deployment.devResponse.Resource;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;

public class CleanDeviceHandler
extends AbstractDeviceDeploymentCommand {
    @Override
    protected void executeCommand(IDeviceManagementInteractor executor) throws DeploymentException {
        List resources;
        try {
            resources = executor.queryResources();
        }
        catch (Exception e) {
            throw new DeploymentException("Error while querying resources: " + e.getMessage(), (Throwable)e);
        }
        for (Resource res : resources) {
            try {
                executor.deleteResource(res.getName());
            }
            catch (Exception e) {
                throw new DeploymentException("Error while deleting resource " + res.getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected String getErrorMessageHeader() {
        return Messages.CleanDeviceHandler_CleanDeviceError;
    }
}

