/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.fordiac.ide.deployment.data.DeviceDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.ResourceDeploymentData;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class DeploymentLaunchValue {
    private final String name;
    private final Optional<VarDeclaration> refElement;
    private String value;

    public DeploymentLaunchValue(String name, Optional<VarDeclaration> refElement, String value) {
        this.name = Objects.requireNonNull(name);
        this.refElement = Objects.requireNonNull(refElement);
        this.value = Objects.requireNonNullElse(value, "");
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = Objects.requireNonNullElse(value, "");
    }

    public String getName() {
        return this.name;
    }

    public Optional<VarDeclaration> getRefElement() {
        return this.refElement;
    }

    public void applyTo(Collection<DeviceDeploymentData> deploymentData) throws DeploymentException {
        if (this.refElement.isEmpty() || this.value.isEmpty()) {
            return;
        }
        Optional resourceData = this.findDeviceData(deploymentData).flatMap(this::findResourceData);
        if (resourceData.isEmpty()) {
            return;
        }
        try {
            Value refValue = VariableOperations.newVariable((VarDeclaration)this.refElement.get(), (String)this.value).getValue();
            DeploymentDebugWatchUtils.resolveSubappInterfaceEndpoints(this.refElement.get()).forEachOrdered(endpoint -> {
                Value paramValue = DeploymentLaunchValue.convertValue(endpoint, refValue);
                String paramName = DeploymentDebugWatchUtils.getResourceRelativeName(endpoint.element(), DeploymentDebugWatchUtils.getResource(endpoint.element()));
                Variable paramVariable = VariableOperations.newVariable((VarDeclaration)((VarDeclaration)endpoint.element()), (Value)paramValue);
                ((ResourceDeploymentData)resourceData.get()).addParameter(paramName, paramVariable.toString(false));
            });
        }
        catch (EvaluatorException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentLaunchValue_Error, this.name), (Throwable)e);
        }
    }

    private Optional<DeviceDeploymentData> findDeviceData(Collection<DeviceDeploymentData> deploymentData) {
        Device device = DeploymentDebugWatchUtils.getDevice((INamedElement)this.refElement.get());
        return deploymentData.stream().filter(data -> data.getDevice() == device).findAny();
    }

    private Optional<ResourceDeploymentData> findResourceData(DeviceDeploymentData deploymentData) {
        Resource resource = DeploymentDebugWatchUtils.getResource((INamedElement)this.refElement.get());
        return deploymentData.getResData().stream().filter(data -> data.getRes() == resource).findAny();
    }

    private static Value convertValue(DeploymentDebugWatchUtils.SubAppConnectionEndpoint<?> endpoint, Value value) throws EvaluatorException {
        if (endpoint.negate()) {
            return ValueOperations.bitwiseNot((Value)value);
        }
        return value;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeploymentLaunchValue other = (DeploymentLaunchValue)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return String.format("%s [name=%s, value=%s]", this.getClass().getName(), this.name, this.value);
    }
}

