/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ZoomFitPageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ZoomManager zoomManager;
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (part != null && (zoomManager = (ZoomManager)part.getAdapter(ZoomManager.class)) != null) {
            if (ZoomFitPageHandler.isZoomAll(currentSelection)) {
                Display.getDefault().syncExec(() -> zoomManager.setZoomAsText(ZoomManager.FIT_ALL));
            } else {
                ZoomFitPageHandler.zoomSelection(currentSelection, zoomManager);
            }
        }
        return Status.OK_STATUS;
    }

    private static boolean isZoomAll(ISelection currentSelection) {
        IStructuredSelection structSel;
        if (currentSelection == null || currentSelection.isEmpty()) {
            return false;
        }
        if (currentSelection instanceof IStructuredSelection && (structSel = (IStructuredSelection)currentSelection).size() == 1) {
            EditPart ep;
            Object firstEl = structSel.getFirstElement();
            return firstEl instanceof EditPart && (ep = (EditPart)firstEl).getParent() == ep.getRoot();
        }
        return false;
    }

    private static void zoomSelection(ISelection currentSelection, ZoomManager zoomManager) {
        Rectangle zoomBounds = ZoomFitPageHandler.getZoomBoundsFromSelection(currentSelection);
        if (zoomBounds != null) {
            double newZoom = ZoomFitPageHandler.getZoomFactor(zoomBounds, zoomManager);
            Display.getDefault().syncExec(() -> {
                zoomManager.setZoom(newZoom);
                Point newPos = ZoomFitPageHandler.getScrollLocation(currentSelection, zoomManager);
                zoomManager.setViewLocation(newPos);
            });
        }
    }

    private static Rectangle getZoomBoundsFromSelection(ISelection currentSelection) {
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)currentSelection;
            Rectangle zoomBounds = null;
            for (Object ob : structSel.toList()) {
                if (!(ob instanceof GraphicalEditPart)) continue;
                GraphicalEditPart gep = (GraphicalEditPart)ob;
                Rectangle bounds = new Rectangle(gep.getFigure().getBounds());
                gep.getFigure().translateToAbsolute((Translatable)bounds);
                if (zoomBounds == null) {
                    zoomBounds = bounds;
                    continue;
                }
                zoomBounds.union(bounds);
            }
            return zoomBounds;
        }
        return null;
    }

    private static double getZoomFactor(Rectangle zoomBounds, ZoomManager zoomManager) {
        Dimension available = zoomManager.getViewport().getClientArea().getSize();
        double scaleX = Math.min((double)available.width * zoomManager.getZoom() / (double)zoomBounds.width, zoomManager.getMaxZoom());
        double scaleY = Math.min((double)available.height * zoomManager.getZoom() / (double)zoomBounds.height, zoomManager.getMaxZoom());
        return Math.min(scaleX, scaleY);
    }

    private static Point getScrollLocation(ISelection currentSelection, ZoomManager zoomManager) {
        Rectangle zoomBounds = ZoomFitPageHandler.getZoomBoundsFromSelection(currentSelection);
        if (zoomBounds != null) {
            Dimension size = zoomManager.getViewport().getClientArea().getSize();
            return zoomBounds.getCenter().translate(-size.width / 2, -size.height / 2).translate(zoomManager.getViewport().getViewLocation());
        }
        return zoomManager.getViewport().getViewLocation();
    }
}

