/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.providers.RowHeaderDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.ImportTransfer;
import org.eclipse.fordiac.ide.ui.widget.nattable.I4diacNatTableUtil;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableColumn;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.nattable.PasteDataFromClipboardCommandHandler;
import org.eclipse.gef.commands.Command;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.copy.command.PasteDataCommand;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class PasteDataImportFromClipboardCommandHandler
extends PasteDataFromClipboardCommandHandler {
    private final BiFunction<TypeLibrary, String, TypeEntry> typeResolver;
    private final CommandExecutor commandExecutor;
    private final Map<String, String> conflicts = new HashMap<String, String>();
    private final NatTableColumnProvider<? extends NatTableColumn> columnProvider;
    private final List<? extends NatTableColumn> columns;
    private Map<String, List<Integer>> importContent;

    public PasteDataImportFromClipboardCommandHandler(SelectionLayer selectionLayer, CommandExecutor commandExecutor, BiFunction<TypeLibrary, String, TypeEntry> typeResolver, NatTableColumnProvider<? extends NatTableColumn> columnProvider, List<? extends NatTableColumn> columns, RowHeaderDataProvider rowHeaderDataProvider) {
        super(selectionLayer, commandExecutor instanceof I4diacNatTableUtil ? (section = (I4diacNatTableUtil)commandExecutor) : null, rowHeaderDataProvider);
        I4diacNatTableUtil section;
        this.commandExecutor = commandExecutor;
        this.typeResolver = typeResolver;
        this.columnProvider = columnProvider;
        this.columns = columns;
    }

    protected boolean doCommand(PasteDataCommand command) {
        LibraryElement rootElement = (LibraryElement)EditorUtils.getCurrentActiveEditor().getAdapter(LibraryElement.class);
        if (rootElement != null) {
            this.importContent = PasteDataImportFromClipboardCommandHandler.getClipboardImports();
            this.importContent.keySet().stream().map(imp -> this.getImportNamespace(rootElement, (String)imp)).filter(Objects::nonNull).forEach(namespace -> this.commandExecutor.executeCommand((Command)new AddNewImportCommand(rootElement, namespace)));
        }
        super.doCommand(command);
        this.conflicts.clear();
        return true;
    }

    protected String[][] parseContent(Object contents) {
        String[][] content = super.parseContent(contents);
        if (this.conflicts.isEmpty() || this.selectionLayer.getSelectionModel().getSelections().isEmpty()) {
            return content;
        }
        PositionCoordinate location = this.selectionLayer.getSelectionAnchor();
        for (NatTableColumn natTableColumn : this.columns) {
            int idx = this.columnProvider.getColumns().indexOf(natTableColumn);
            int colIndex = idx - location.getColumnPosition();
            int i = 0;
            while (i < content.length) {
                String[] row = content[i];
                if (colIndex >= 0 && colIndex < row.length && this.conflicts.containsKey(row[colIndex]) && this.importContent.containsKey(this.conflicts.get(row[colIndex])) && this.importContent.get(this.conflicts.get(row[colIndex])).contains(i)) {
                    row[colIndex] = this.conflicts.get(row[colIndex]);
                }
                ++i;
            }
        }
        return content;
    }

    private String getImportNamespace(LibraryElement rootElement, String imp) {
        if (ImportHelper.matchesImports((String)imp, (List)ImportHelper.getImports((LibraryElement)rootElement))) {
            return null;
        }
        TypeEntry resolvedType = (TypeEntry)ImportHelper.resolveImport((String)PackageNameHelper.extractPlainTypeName((String)imp), (EObject)rootElement, name -> this.typeResolver.apply(rootElement.getTypeLibrary(), (String)name), name -> null);
        if (resolvedType == null) {
            return imp;
        }
        if (resolvedType.getFullTypeName().equalsIgnoreCase(imp)) {
            return null;
        }
        this.conflicts.put(PackageNameHelper.extractPlainTypeName((String)imp), imp);
        return null;
    }

    protected static Map<String, List<Integer>> getClipboardImports() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        try {
            Object content = clipboard.getContents((Transfer)ImportTransfer.getInstance());
            if (content instanceof Map) {
                Map map;
                Map map2 = map = (Map)content;
                return map2;
            }
            Map<String, List<Integer>> map = Map.of();
            return map;
        }
        finally {
            clipboard.dispose();
        }
    }

    protected void updateNewRow(int[] rowIndices) {
        int i = 0;
        while (i < rowIndices.length) {
            int rowIndex = rowIndices[i];
            ILayer iLayer = this.selectionLayer.getUnderlyingLayerByPosition(0, 0);
            if (iLayer instanceof DataLayer) {
                DataLayer dataLayer = (DataLayer)iLayer;
                IDataProvider dataProvider = dataLayer.getDataProvider();
                for (NatTableColumn natTableColumn : this.columns) {
                    int colIdx = this.columnProvider.getColumns().indexOf(natTableColumn);
                    Object cellValue = dataProvider.getDataValue(colIdx, rowIndex);
                    if (!this.conflicts.containsKey(cellValue) || !this.importContent.containsKey(this.conflicts.get(cellValue)) || !this.importContent.get(this.conflicts.get(cellValue)).contains(i)) continue;
                    dataProvider.setDataValue(colIdx, rowIndex, (Object)this.conflicts.get(cellValue));
                }
            }
            ++i;
        }
    }

    public Class<PasteDataCommand> getCommandClass() {
        return PasteDataCommand.class;
    }
}

