/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Level;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Node;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class HierarchyManagerUtil {
    private HierarchyManagerUtil() {
    }

    public static EObject getElementReferencedbyLeaf(Leaf leaf, IProject project) {
        LibraryElement object = HierarchyManagerUtil.getTypeEditable(leaf.getContainerFileName(), project);
        String[] refPath = leaf.getRef().split("\\.");
        if (object instanceof AutomationSystem) {
            AutomationSystem sys = (AutomationSystem)object;
            return HierarchyManagerUtil.findRefInSystem(sys, refPath);
        }
        if (object instanceof SubAppType) {
            SubAppType subAppType = (SubAppType)object;
            return HierarchyManagerUtil.parseSubappPath(subAppType.getFBNetwork(), refPath);
        }
        return null;
    }

    public static LibraryElement getTypeEditable(String containerFileName, IProject project) {
        IFile file;
        if (project != null && (file = project.getFile(containerFileName)).exists()) {
            LibraryElement libraryElement = LibraryElementProvider.INSTANCE.getLibraryElement((IEditorInput)new FileEditorInput(file));
            if (libraryElement != null) {
                return libraryElement;
            }
            TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            if (typeEntry != null) {
                return typeEntry.getType();
            }
        }
        return null;
    }

    public static EObject findRefInSystem(AutomationSystem system, String[] refPath) {
        Application retVal = system.getApplicationNamed(refPath[0]);
        if (retVal != null) {
            if (refPath.length > 1) {
                retVal = HierarchyManagerUtil.parseSubappPath(retVal.getFBNetwork(), Arrays.copyOfRange(refPath, 1, refPath.length));
            }
        } else if (refPath.length > 2 && (retVal = system.getDeviceNamed(refPath[0])) != null && (retVal = ((Device)retVal).getResourceNamed(refPath[1])) != null && refPath.length > 2) {
            retVal = HierarchyManagerUtil.parseSubappPath(((Resource)retVal).getFBNetwork(), Arrays.copyOfRange(refPath, 2, refPath.length));
        }
        return retVal;
    }

    public static EObject parseSubappPath(FBNetwork network, String[] path) {
        FBNetworkElement retVal = null;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            retVal = network.getElementNamed(element);
            if (retVal instanceof SubApp) {
                SubApp subApp = (SubApp)retVal;
                network = subApp.getSubAppNetwork();
                if (network == null) {
                    network = subApp.loadSubAppNetwork();
                }
            } else if (retVal instanceof SubAppType) {
                SubAppType subAppType = (SubAppType)retVal;
                network = subAppType.getFBNetwork();
            } else {
                return null;
            }
            ++n2;
        }
        return retVal;
    }

    public static List<Leaf> searchLeaf(RootLevel rootLevel, LeafMatcher matcher) {
        ArrayList<Leaf> result = new ArrayList<Leaf>();
        for (Level level : rootLevel.getLevels()) {
            HierarchyManagerUtil.searchLeaf(level, result, matcher);
        }
        return result;
    }

    public static List<Leaf> searchLeaf(Level level, List<Leaf> result, LeafMatcher matcher) {
        for (Node node : level.getChildren()) {
            Leaf leaf;
            if (node instanceof Level) {
                Level l = (Level)node;
                HierarchyManagerUtil.searchLeaf(l, result, matcher);
            }
            if (!(node instanceof Leaf) || !matcher.match(leaf = (Leaf)node)) continue;
            result.add(leaf);
        }
        return result;
    }

    @FunctionalInterface
    public static interface LeafMatcher {
        public boolean match(Leaf var1);
    }
}

