/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.AnySCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyStringValue;
import org.eclipse.fordiac.ide.model.eval.value.CharValue;
import org.eclipse.fordiac.ide.model.value.StringValueConverter;

public final class StringValue
implements AnyStringValue,
AnySCharsValue {
    public static final StringValue DEFAULT = new StringValue(new byte[0]);
    private final byte[] value;

    private StringValue(byte[] value) {
        this.value = value;
    }

    public static StringValue toStringValue(String value) {
        return StringValue.toStringValue(value, 65534);
    }

    public static StringValue toStringValue(String value, int maxLength) {
        return new StringValue(StringValue.truncate(value.getBytes(StandardCharsets.UTF_8), maxLength));
    }

    public static StringValue toStringValue(AnyCharsValue value) {
        return StringValue.toStringValue(value, 65534);
    }

    public static StringValue toStringValue(AnyCharsValue value, int maxLength) {
        if (value instanceof CharValue) {
            CharValue charValue = (CharValue)value;
            return maxLength > 0 ? new StringValue(new byte[]{(byte)charValue.charValue()}) : DEFAULT;
        }
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            return new StringValue(StringValue.truncate(stringValue.value, maxLength));
        }
        return StringValue.toStringValue(value.stringValue(), maxLength);
    }

    @Override
    public CharValue charAt(int index) {
        return CharValue.toCharValue(index > 0 && index <= this.value.length ? this.value[index - 1] : (byte)0);
    }

    public StringValue withCharAt(int index, CharValue c) {
        if (index <= 0) {
            throw new StringIndexOutOfBoundsException(index);
        }
        byte[] newValue = Arrays.copyOf(this.value, Math.max(this.value.length, index));
        newValue[index - 1] = (byte)c.charValue();
        return new StringValue(newValue);
    }

    public StringType getType() {
        return IecTypes.ElementaryTypes.STRING;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public char charValue() {
        return this.value.length > 0 ? (char)this.value[0] : (char)'\u0000';
    }

    @Override
    public String stringValue() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringValue other = (StringValue)obj;
        return Arrays.equals(this.value, other.value);
    }

    public String toString() {
        return StringValueConverter.INSTANCE.toString(this.stringValue());
    }

    private static byte[] truncate(byte[] value, int maxLength) {
        if (value.length > maxLength) {
            return Arrays.copyOf(value, maxLength);
        }
        return value;
    }
}

