/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.VarInOutHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class VarDeclarationAnnotations {
    public static boolean validateMultipleInputConnections(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isIsInput() && varDeclaration.getInputConnections().size() > 1) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 27, Messages.VarDeclarationAnnotations_MultipleInputConnections, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, (EStructuralFeature)LibraryElementPackage.Literals.IINTERFACE_ELEMENT__INPUT_CONNECTIONS, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateNoValueForGenericTypeVariable(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (IecTypes.GenericTypes.isAnyType(varDeclaration.getType()) && VarDeclarationAnnotations.hasValue(varDeclaration) && varDeclaration.getBlockFBNetworkElement() == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.fordiac.ide.model.libraryElement", 28, Messages.VarDeclarationAnnotations_ShouldNotSpecifyValueForGenericVariableInType, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateIllegalVariableLengthArrayVariable(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isArray() && !varDeclaration.isInOutVar() && TypeDeclarationParser.isVariableArrayBounds(varDeclaration.getArraySize().getValue()) && !(varDeclaration.getFBType() instanceof FunctionFBType) && !(varDeclaration.eContainer() instanceof Method)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 29, Messages.VarDeclarationAnnotations_IllegalVariableLengthArray, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateNoValueForVariableLengthArrayVariable(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isArray() && VarDeclarationAnnotations.hasValue(varDeclaration) && TypeDeclarationParser.isVariableArrayBounds(varDeclaration.getArraySize().getValue())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 30, Messages.VarDeclarationAnnotations_MustNotSpecifyValueForVariableWithVariableArrayBounds, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateValueForGenericInstanceVariable(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isIsInput() && varDeclaration.getInputConnections().isEmpty() && IecTypes.GenericTypes.isAnyType(varDeclaration.getType()) && !VarDeclarationAnnotations.hasValue(varDeclaration) && varDeclaration.getBlockFBNetworkElement() != null && varDeclaration.getBlockFBNetworkElement().eContainingFeature() != LibraryElementPackage.Literals.BASE_FB_TYPE__INTERNAL_FBS) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.fordiac.ide.model.libraryElement", 31, Messages.VarDeclarationAnnotations_ShouldSpecifyValueForGenericVariableInInstance, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateValueOverriddenBySubAppInput(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isIsInput() && VarDeclarationAnnotations.hasValue(varDeclaration) && !varDeclaration.getInputConnections().isEmpty() && ((Connection)varDeclaration.getInputConnections().getFirst()).getSourceElement() instanceof SubApp && ((Connection)varDeclaration.getInputConnections().getFirst()).getSource().isIsInput()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.fordiac.ide.model.libraryElement", 32, Messages.VarDeclarationAnnotations_ValueOverriddenBySubAppInput, FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutSourceTypeIsWellDefined(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isInOutVar() && varDeclaration.isIsInput() && varDeclaration.getBlockFBNetworkElement() != null && varDeclaration.getInputConnections().isEmpty() && (varDeclaration.isArray() && TypeDeclarationParser.isVariableArrayBounds(varDeclaration.getArraySize().getValue()) || IecTypes.GenericTypes.isAnyType(varDeclaration.getType()))) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 33, MessageFormat.format(Messages.ConnectionValidator_VarInOutSourceNotWellDefined, varDeclaration.getFullTypeName()), FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutIsWithed(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isInOutVar() && varDeclaration.getWiths().isEmpty() && varDeclaration.getBlockFBNetworkElement() == null && !VarDeclarationAnnotations.isSubappTypeInterface(varDeclaration)) {
            if (diagnostics != null) {
                String string;
                EObject eObject = varDeclaration.eContainer().eContainer();
                if (eObject instanceof FB) {
                    FB fb = (FB)eObject;
                    string = fb.getName();
                } else {
                    string = ((INamedElement)varDeclaration.eContainer().eContainer()).getName();
                }
                String typeName = string;
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 34, MessageFormat.format(varDeclaration.isIsInput() ? Messages.ConnectionValidator_VarInOutInputSideHasNoWith : Messages.ConnectionValidator_VarInOutOutputSideHasNoWith, varDeclaration.getName(), typeName), FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutSubappInterface(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (varDeclaration.isInOutVar() && varDeclaration.getBlockFBNetworkElement() instanceof SubApp && VarDeclarationAnnotations.hasAnyOutputConnections(varDeclaration) && !VarDeclarationAnnotations.hasAnyInputConnections(varDeclaration)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 35, MessageFormat.format(varDeclaration.isIsInput() ? Messages.VarDeclarationAnnotations_VarInOutLeftNotConnected : Messages.VarDeclarationAnnotations_VarInOutRightNotConnected, varDeclaration.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static boolean validateVarInOutSubappNetwork(VarDeclaration varDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        VarDeclaration source;
        if (varDeclaration.isInOutVar() && !varDeclaration.isIsInput() && (VarDeclarationAnnotations.isUntypedSubappInterface(varDeclaration) || VarDeclarationAnnotations.isSubappTypeInterface(varDeclaration)) && !varDeclaration.getInOutVarOpposite().getOutputConnections().isEmpty() && (source = VarInOutHelper.getDefiningVarInOutDeclaration(varDeclaration)) != null && source.eContainer() != varDeclaration.eContainer()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 36, MessageFormat.format(Messages.VarDeclarationAnnotations_VarInOutSubappNetwork, varDeclaration.getName()), FordiacMarkerHelper.getDiagnosticData((EObject)varDeclaration, new String[0])));
            }
            return false;
        }
        return true;
    }

    public static VarDeclaration getInOutVarOpposite(VarDeclaration inOutVar) {
        InterfaceList interfaceList = (InterfaceList)inOutVar.eContainer();
        if (inOutVar.isInOutVar()) {
            if (inOutVar.isIsInput()) {
                return (VarDeclaration)interfaceList.getOutMappedInOutVars().get(interfaceList.getInOutVars().indexOf((Object)inOutVar));
            }
            return (VarDeclaration)interfaceList.getInOutVars().get(interfaceList.getOutMappedInOutVars().indexOf((Object)inOutVar));
        }
        return inOutVar;
    }

    static boolean hasValue(VarDeclaration varDeclaration) {
        return varDeclaration.getValue() != null && varDeclaration.getValue().getValue() != null && !varDeclaration.getValue().getValue().isEmpty();
    }

    static boolean isSubappTypeInterface(VarDeclaration varDeclaration) {
        InterfaceList interfaceList;
        EObject eObject = varDeclaration.eContainer();
        return eObject instanceof InterfaceList && (interfaceList = (InterfaceList)eObject).eContainer() instanceof SubAppType;
    }

    static boolean isUntypedSubappInterface(VarDeclaration varDeclaration) {
        SubApp subapp;
        BlockFBNetworkElement blockFBNetworkElement = varDeclaration.getBlockFBNetworkElement();
        return blockFBNetworkElement instanceof SubApp && !(subapp = (SubApp)blockFBNetworkElement).isTyped();
    }

    static boolean hasAnyInputConnections(VarDeclaration varDeclaration) {
        if (varDeclaration == null) {
            return false;
        }
        VarDeclaration typeIE = varDeclaration.findInTypeInterface();
        return !varDeclaration.getInputConnections().isEmpty() || typeIE != null && !typeIE.getInputConnections().isEmpty();
    }

    static boolean hasAnyOutputConnections(VarDeclaration varDeclaration) {
        if (varDeclaration == null) {
            return false;
        }
        VarDeclaration typeIE = varDeclaration.findInTypeInterface();
        return !varDeclaration.getOutputConnections().isEmpty() || typeIE != null && !typeIE.getOutputConnections().isEmpty();
    }

    private VarDeclarationAnnotations() {
        throw new UnsupportedOperationException("Helper class must not be instantiated");
    }
}

