/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary.impl;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.dataimport.BlockTypeImporter;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.InterfaceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.impl.AbstractCheckedTypeEntryImpl;
import org.eclipse.fordiac.ide.model.typelibrary.impl.AbstractTypeEntryImpl;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public abstract class AbstractInterfaceTypeEntryImpl<T extends FBType>
extends AbstractCheckedTypeEntryImpl<T>
implements InterfaceTypeEntry {
    private SoftReference<FBType> interfaceTypeRef;
    private final AtomicLong lastInterfaceModificationTimestamp = new AtomicLong(-1L);
    private final AtomicReference<Set<TypeEntry>> ifDependencies = new AtomicReference(Collections.emptySet());

    protected AbstractInterfaceTypeEntryImpl(Class<T> typeClass) {
        super(typeClass);
    }

    private InterfaceList basicGetInterface() {
        FBType interfaceTypeCache;
        SoftReference<FBType> interfaceRefCached = this.interfaceTypeRef;
        if (interfaceRefCached != null && (interfaceTypeCache = interfaceRefCached.get()) != null) {
            return interfaceTypeCache.getInterfaceList();
        }
        return null;
    }

    @Override
    protected FBType basicGetType() {
        return (FBType)super.basicGetType();
    }

    protected synchronized NotificationChain basicSetInterface(FBType newIfType, NotificationChain notifications) {
        FBType oldIfType;
        FBType fBType = oldIfType = this.interfaceTypeRef != null ? this.interfaceTypeRef.get() : null;
        if (newIfType != null) {
            this.encloseInResource(newIfType);
            newIfType.setTypeEntry(this);
            this.interfaceTypeRef = new SoftReference<FBType>(newIfType);
        } else {
            this.interfaceTypeRef = null;
        }
        if (this.eNotificationRequired()) {
            notifications = AbstractInterfaceTypeEntryImpl.chainNotification(notifications, new AbstractTypeEntryImpl.TypeEntryNotificationImpl(this, 1, "TYPE_ENTRY_INTERFACE_FEATURE", 7, oldIfType, newIfType));
        }
        return notifications;
    }

    private FBType createIntefaceTypeFromTypeCache(FBType fbTypeCache) {
        FBType interfaceType = (FBType)EcoreUtil.create((EClass)fbTypeCache.eClass());
        interfaceType.setName(fbTypeCache.getName());
        interfaceType.setComment(fbTypeCache.getComment());
        interfaceType.setCompilerInfo((CompilerInfo)EcoreUtil.copy((EObject)fbTypeCache.getCompilerInfo()));
        interfaceType.setInterfaceList(fbTypeCache.getInterfaceList().copy());
        this.updateInterfaceDependencies(StreamSupport.stream(Spliterators.spliteratorUnknownSize(interfaceType.eAllContents(), 0), false).map(EObject::eCrossReferences).flatMap(Collection::stream).filter(LibraryElement.class::isInstance).map(LibraryElement.class::cast).map(LibraryElement::getTypeEntry).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet()));
        return interfaceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterfaceList getInterface() {
        InterfaceList interfaceList = this.basicGetInterface();
        if (interfaceList != null) {
            return interfaceList;
        }
        NotificationChain notifications = null;
        AbstractInterfaceTypeEntryImpl abstractInterfaceTypeEntryImpl = this;
        synchronized (abstractInterfaceTypeEntryImpl) {
            FBType newInterfaceType;
            long modificationStamp;
            block9: {
                IFile fileCached;
                block8: {
                    interfaceList = this.basicGetInterface();
                    if (interfaceList != null) {
                        return interfaceList;
                    }
                    fileCached = this.getFile();
                    if (fileCached != null) break block8;
                    return null;
                }
                modificationStamp = fileCached.getModificationStamp();
                newInterfaceType = this.loadInterface();
                if (newInterfaceType != null) break block9;
                return null;
            }
            interfaceList = newInterfaceType.getInterfaceList();
            notifications = this.basicSetInterface(newInterfaceType, notifications);
            this.lastInterfaceModificationTimestamp.set(modificationStamp);
        }
        if (notifications != null) {
            notifications.dispatch();
        }
        return interfaceList;
    }

    private final boolean isInterfaceFileContentChanged() {
        IFile fileCached = this.getFile();
        if (fileCached != null) {
            long modificationStamp = fileCached.getModificationStamp();
            return modificationStamp != -1L && modificationStamp != this.lastInterfaceModificationTimestamp.get();
        }
        return false;
    }

    private FBType loadInterface() {
        FBType fbTypeCache = this.basicGetType();
        if (fbTypeCache != null) {
            return this.createIntefaceTypeFromTypeCache(fbTypeCache);
        }
        try {
            BlockTypeImporter importer = this.getImporter();
            FBType interfaceType = importer.loadInterface();
            this.updateInterfaceDependencies(importer.getDependencies());
            return interfaceType;
        }
        catch (Exception e) {
            FordiacLogHelper.logWarning((String)("Error loading type " + this.getFile().getName() + ": " + e.getMessage()), (Exception)e);
            return null;
        }
    }

    @Override
    protected abstract BlockTypeImporter getImporter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChanged(Notification notification) {
        if ((notification.getFeature() == "TYPE_ENTRY_TYPE_FEATURE" || notification.getFeature() == "TYPE_ENTRY_TYPE_LIBRARY") && this.ifDependencies.get().contains(notification.getNotifier())) {
            NotificationChain notifications = null;
            AbstractInterfaceTypeEntryImpl abstractInterfaceTypeEntryImpl = this;
            synchronized (abstractInterfaceTypeEntryImpl) {
                notifications = this.basicSetInterface(null, notifications);
            }
            if (notifications != null) {
                notifications.dispatch();
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected NotificationChain performTypeRefresh(NotificationChain notifications) {
        if (this.isInterfaceFileContentChanged()) {
            notifications = this.basicSetInterface(null, notifications);
        }
        return super.performTypeRefresh(notifications);
    }

    private void updateInterfaceDependencies(Set<TypeEntry> dependencies) {
        Set<TypeEntry> oldDependencies = this.ifDependencies.getAndSet(Set.copyOf(dependencies));
        oldDependencies.stream().filter(Predicate.not(dependencies::contains)).forEachOrdered(entry -> {
            boolean bl = entry.eAdapters().remove((Object)this);
        });
        dependencies.stream().filter(Predicate.not(oldDependencies::contains)).forEachOrdered(entry -> {
            boolean bl = entry.eAdapters().add((Object)this);
        });
    }

    @Override
    protected NotificationChain updateTypeOnSave(LibraryElement savedType, NotificationChain notifications) {
        FBType newInterfaceType = this.createIntefaceTypeFromTypeCache((FBType)savedType);
        long modificationStamp = this.getFile().getModificationStamp();
        notifications = this.basicSetInterface(newInterfaceType, notifications);
        this.lastInterfaceModificationTimestamp.set(modificationStamp);
        return super.updateTypeOnSave(savedType, notifications);
    }
}

