/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public final class ModelHelper {
    public static LibraryElement getLibraryElementFromContextChecked(EObject context) {
        EObject eObject = EcoreUtil.getRootContainer((EObject)context);
        if (eObject instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)eObject;
            return libraryElement;
        }
        throw new IllegalStateException("Could not determine root LibraryElement for given element: " + String.valueOf(context));
    }

    public static LibraryElement getLibraryElementFromContext(EObject context) {
        EObject eObject = EcoreUtil.getRootContainer((EObject)context);
        if (eObject instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)eObject;
            return libraryElement;
        }
        return null;
    }

    public static IFile getFileFromContextChecked(EObject context) {
        TypeEntry typeEntry = ModelHelper.getLibraryElementFromContextChecked(context).getTypeEntry();
        if (typeEntry != null) {
            return typeEntry.getFile();
        }
        throw new IllegalStateException("No type entry set for root element of: " + String.valueOf(context));
    }

    public static IFile getFileFromContext(EObject context) {
        TypeEntry typeEntry;
        LibraryElement libraryElement = ModelHelper.getLibraryElementFromContext(context);
        if (libraryElement != null && (typeEntry = libraryElement.getTypeEntry()) != null) {
            return libraryElement.getTypeEntry().getFile();
        }
        return null;
    }

    public static IProject getProjectFromContextChecked(EObject context) {
        TypeLibrary typeLibrary = ModelHelper.getLibraryElementFromContextChecked(context).getTypeLibrary();
        if (typeLibrary != null) {
            return typeLibrary.getProject();
        }
        throw new IllegalStateException("Could not determine type library for root element of: " + String.valueOf(context));
    }

    public static IProject getProjectFromContext(EObject context) {
        TypeLibrary typeLibrary;
        LibraryElement libraryElement = ModelHelper.getLibraryElementFromContext(context);
        if (libraryElement != null && (typeLibrary = libraryElement.getTypeLibrary()) != null) {
            return typeLibrary.getProject();
        }
        return null;
    }

    private ModelHelper() {
        throw new UnsupportedOperationException();
    }
}

