/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.copy;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.copy.CopyResourceChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.copy.ICopyRefactoringQueries;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.CopyParticipant;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class FordiacCopyProcessor
extends CopyProcessor {
    private final IResource[] files;
    private final boolean[] doCopy;
    private final IContainer destination;
    private final ReorgExecutionLog log;
    private final ICopyRefactoringQueries queries;
    private boolean canceled = false;

    public FordiacCopyProcessor(IResource[] files, IContainer destination, ICopyRefactoringQueries queries) {
        this.files = files;
        this.destination = destination;
        this.queries = queries;
        this.doCopy = new boolean[files.length];
        this.log = new ReorgExecutionLog();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        int i = 0;
        while (i < this.files.length) {
            IResource file = this.files[i];
            ExistsResolve resolve = this.handleAlreadyExists(file);
            if (resolve == ExistsResolve.OVERWRITE) {
                this.doCopy[i] = true;
            } else if (resolve == ExistsResolve.CANCEL_ALL) {
                this.canceled = true;
                break;
            }
            ++i;
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.canceled) {
            return new NullChange();
        }
        CompositeChange compChange = new CompositeChange(Messages.FordiacCopyProcessor_CompositeChangeName);
        int i = 0;
        while (i < this.files.length) {
            if (this.doCopy[i]) {
                compChange.add((Change)new CopyResourceChange(this.files[i], this.destination));
            }
            ++i;
        }
        return compChange;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        if (this.canceled) {
            return null;
        }
        String[] affectedNatures = SystemManager.getNatureIDs();
        ArrayList<CopyParticipant> result = new ArrayList<CopyParticipant>();
        int i = 0;
        while (i < this.files.length) {
            if (this.doCopy[i]) {
                CopyParticipant[] participants = ParticipantManager.loadCopyParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.files[i], (CopyArguments)new CopyArguments((Object)this.destination, this.log), (String[])affectedNatures, (SharableParticipants)sharedParticipants);
                result.addAll(Arrays.asList(participants));
            }
            ++i;
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public Object[] getElements() {
        return this.files;
    }

    public String getIdentifier() {
        return "org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer.copyProcessor";
    }

    public String getProcessorName() {
        return Messages.FordiacCopyProcessor_Name;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public static boolean areEqualInWorkspaceOrOnDisk(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.equals((Object)r2)) {
            return true;
        }
        URI r1Location = r1.getLocationURI();
        URI r2Location = r2.getLocationURI();
        if (r1Location == null || r2Location == null) {
            return false;
        }
        return r1Location.equals(r2Location);
    }

    private ExistsResolve handleAlreadyExists(IResource file) {
        IResource current = this.destination.findMember(file.getName());
        if (current == null || !current.exists()) {
            return ExistsResolve.OVERWRITE;
        }
        if (FordiacCopyProcessor.areEqualInWorkspaceOrOnDisk(file, current)) {
            return this.queries.queryOverwriteSelf(file, this.destination);
        }
        if (current instanceof IFolder || !(current instanceof IFile)) {
            return ExistsResolve.OVERWRITE;
        }
        return this.queries.queryOverwrite(file, this.destination);
    }

    public static enum ExistsResolve {
        OVERWRITE,
        DONT_COPY,
        CANCEL_ALL;

    }
}

