/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.move;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ConfigurableFBManagement;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.DataTypeModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEditChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.RefactoringUtil;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateFBInstanceModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.move.MoveTypeModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.move.UpdateTypeEntryFileChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;

public class MoveTypeRefactoringParticipant
extends MoveParticipant {
    private IResource resource;
    private IContainer destination;

    protected boolean initialize(Object element) {
        if (element instanceof IResource) {
            IResource res = (IResource)element;
            Object object = this.getArguments().getDestination();
            if (object instanceof IContainer) {
                IContainer dest = (IContainer)object;
                this.resource = res;
                this.destination = dest;
                return RefactoringUtil.containsTypeEntryFile(res);
            }
        }
        return false;
    }

    public String getName() {
        return Messages.MoveTypeToPackage;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        String packageNameContainer = PackageNameHelper.getPackageNameFromContainer((IContainer)this.destination);
        Optional errorMessage = IdentifierVerifier.verifyPackageName((String)packageNameContainer);
        if (errorMessage.isPresent()) {
            status.addFatalError((String)errorMessage.get());
        }
        return status;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList modelEdits = new ArrayList();
        ArrayList<CompositeChange> changes = new ArrayList<CompositeChange>();
        this.processTypeFiles(this.resource, this.destination.getFullPath(), (typeEntry, path) -> {
            IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            String newPackageName = PackageNameHelper.getPackageNameFromFile((IFile)newFile);
            modelEdits.add(new MoveTypeModelEdit(newPackageName, MessageFormat.format(Messages.MoveTypeToPackage_RenamePackageTo, newPackageName), typeEntry.getURI()));
            changes.add((CompositeChange)new UpdateTypeEntryFileChange(typeEntry.getFile(), (TypeEntry)typeEntry, newFile));
        });
        changes.addFirst(ModelEditChange.fromModelEdits(Messages.MoveTypeToPackage, modelEdits));
        return new CompositeChange(Messages.MoveTypeToPackage, (Change[])changes.toArray(Change[]::new));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList modelEdits = new ArrayList();
        this.processTypeFiles(this.resource, this.destination.getFullPath(), (typeEntry, path) -> {
            if (typeEntry instanceof DataTypeEntry) {
                DataTypeEntry dtEntry = (DataTypeEntry)typeEntry;
                MoveTypeRefactoringParticipant.addDataTypeInstanceChanges(modelEdits, dtEntry, path);
            } else {
                MoveTypeRefactoringParticipant.addInstanceChanges(modelEdits, typeEntry);
            }
        });
        return ModelEditChange.fromModelEdits(Messages.MoveTypeToPackage_UpdateInstances, modelEdits);
    }

    private void processTypeFiles(IResource resource, IPath newPath, BiConsumer<TypeEntry, IPath> processor) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            if (entry != null) {
                processor.accept(entry, newPath.append(file.getName()));
            }
        } else if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                this.processTypeFiles(member, newPath.append(container.getName()), processor);
                ++n2;
            }
        }
    }

    private static void addDataTypeInstanceChanges(List<ModelEdit<?>> modelEdits, DataTypeEntry dtEntry, IPath newPath) {
        List searchResult = new DataTypeInstanceSearch(dtEntry).performSearch();
        for (EObject eObject : searchResult) {
            VarDeclaration varDecl;
            if (eObject instanceof VarDeclaration && !((varDecl = (VarDeclaration)eObject).getBlockFBNetworkElement() instanceof ConfigurableFB)) {
                IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newPath);
                modelEdits.add(new DataTypeModelEdit(Messages.MoveTypeToPackage_UpdateDataTypeInstance, EcoreUtil.getURI((EObject)eObject), PackageNameHelper.getFullTypeNameFromFile((IFile)newFile)));
            }
            if (!(eObject instanceof BlockFBNetworkElement)) continue;
            BlockFBNetworkElement elem = (BlockFBNetworkElement)eObject;
            modelEdits.add(new UpdateInstanceModelEdit(elem, (TypeEntry)dtEntry));
        }
    }

    private static void addInstanceChanges(List<ModelEdit<?>> modelEdits, TypeEntry typeEntry) {
        List result = new BlockTypeInstanceSearch(typeEntry).performSearch();
        for (EObject eObject : result) {
            if (!(eObject instanceof BlockFBNetworkElement)) continue;
            BlockFBNetworkElement elem = (BlockFBNetworkElement)eObject;
            modelEdits.add(new UpdateFBInstanceModelEdit(elem, typeEntry));
        }
    }

    private static class UpdateInstanceModelEdit
    extends UpdateFBInstanceModelEdit {
        final String visibleChildrenString;

        public UpdateInstanceModelEdit(BlockFBNetworkElement instance, TypeEntry typeEntry) {
            super(instance, typeEntry);
            String string;
            if (instance instanceof StructManipulator) {
                StructManipulator structManipulator = (StructManipulator)instance;
                string = ConfigurableFBManagement.buildVisibleChildrenString((EList)structManipulator.getMemberVars());
            } else {
                string = "";
            }
            this.visibleChildrenString = string;
        }

        @Override
        protected Command createCommand(BlockFBNetworkElement element) {
            if (element instanceof StructManipulator) {
                StructManipulator demux = (StructManipulator)element;
                LibraryElement libraryElement = this.typeEntry.getType();
                if (libraryElement instanceof StructuredType) {
                    StructuredType structuredType = (StructuredType)libraryElement;
                    return new ChangeStructCommand(demux, (DataType)structuredType, this.visibleChildrenString, true);
                }
            }
            return super.createCommand(element);
        }
    }
}

