/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.errormessages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.fordiac.ide.ui.errormessages.Activator;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessage;
import org.osgi.framework.BundleContext;

public final class ErrorMessenger {
    private static boolean messagesPaused = false;
    private static List<ErrorMessage> pausedMessages = List.of();
    private static Integer lastHash;
    private static final String TOPIC_ERRORMESSAGES = "ORG/ECLIPSE/FORDIAC/IDE/ERRORMESSAGES";
    public static final int USE_DEFAULT_TIMEOUT = -1;
    private static final IEventBroker eventBroker;

    static {
        eventBroker = ErrorMessenger.initEventBroker();
    }

    public static void pauseMessages() {
        messagesPaused = true;
        pausedMessages = new ArrayList<ErrorMessage>();
    }

    public static List<ErrorMessage> unpauseMessages() {
        messagesPaused = false;
        return pausedMessages;
    }

    public static void hashCleared(int hash) {
        if (lastHash != null && hash == lastHash) {
            lastHash = null;
        }
    }

    public static void popUpErrorMessage(String errorMsg) {
        ErrorMessenger.popUpErrorMessage(errorMsg, -1);
    }

    public static void popUpErrorMessage(String errorMsg, int timeout) {
        ErrorMessage m = new ErrorMessage(errorMsg, timeout);
        if (lastHash == null || m.hashCode() != lastHash.intValue()) {
            lastHash = m.hashCode();
            if (messagesPaused) {
                pausedMessages.add(m);
                return;
            }
            if (eventBroker != null) {
                eventBroker.send(TOPIC_ERRORMESSAGES, (Object)m);
            }
        }
    }

    private static IEventBroker initEventBroker() {
        return (IEventBroker)EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext()).get(IEventBroker.class);
    }

    private ErrorMessenger() {
        throw new UnsupportedOperationException();
    }
}

