/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class GradleProjectBuilder {
    public static final String ID = "org.eclipse.buildship.core.gradleprojectbuilder";

    public static void configureOnProject(IProject project) {
        try {
            Preconditions.checkState((boolean)project.isOpen());
            IProjectDescription description = project.getDescription();
            List<ICommand> buildSpecs = Arrays.asList(description.getBuildSpec());
            boolean exists = FluentIterable.from(buildSpecs).anyMatch((Predicate)new Predicate<ICommand>(){

                public boolean apply(ICommand command) {
                    return command.getBuilderName().equals(GradleProjectBuilder.ID);
                }
            });
            if (!exists) {
                ICommand buildSpec = description.newCommand();
                buildSpec.setBuilderName(ID);
                ImmutableList newBuildSpecs = ImmutableList.builder().addAll(buildSpecs).add((Object)buildSpec).build();
                description.setBuildSpec((ICommand[])newBuildSpecs.toArray((Object[])new ICommand[newBuildSpecs.size()]));
                project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            CorePlugin.logger().error(String.format("Failed to add Gradle Project Builder to project %s.", project.getName()));
        }
    }

    public static void deconfigureOnProject(IProject project) {
        try {
            Preconditions.checkState((boolean)project.isOpen());
            IProjectDescription description = project.getDescription();
            List<ICommand> buildSpecs = Arrays.asList(description.getBuildSpec());
            ICommand[] filteredBuildSpecs = (ICommand[])FluentIterable.from(buildSpecs).filter((Predicate)new Predicate<ICommand>(){

                public boolean apply(ICommand command) {
                    return !command.getBuilderName().equals(GradleProjectBuilder.ID);
                }
            }).toArray(ICommand.class);
            if (filteredBuildSpecs.length < buildSpecs.size()) {
                description.setBuildSpec(filteredBuildSpecs);
                project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            CorePlugin.logger().error(String.format("Failed to remove Gradle Project Builder from project %s.", project.getName()));
        }
    }

    private GradleProjectBuilder() {
    }
}

