/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model.annotations;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.annotations.IClassAnnotation;

public class SuppressWarningsAnnotation
implements IClassAnnotation {
    private String suppress = "all";

    @Override
    public CharSequence generate() {
        StringBuilder stringBuilder = new StringBuilder("@SuppressWarnings(");
        String[] suppressedWarnings = this.suppress.split("\\s*,\\s*");
        if (suppressedWarnings.length != 1) {
            stringBuilder.append("{");
        }
        String value = Arrays.stream(suppressedWarnings).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
        stringBuilder.append(value);
        if (suppressedWarnings.length != 1) {
            stringBuilder.append("}");
        }
        stringBuilder.append(")");
        return stringBuilder;
    }

    @Override
    public boolean appliesTo(JavaFileAccess javaFile) {
        return true;
    }

    @Override
    public TypeReference getAnnotationImport() {
        return new TypeReference(SuppressWarnings.class);
    }

    public String toString() {
        return this.generate().toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof SuppressWarningsAnnotation;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public String getSuppress() {
        return this.suppress;
    }

    public void setSuppress(String suppress) {
        this.suppress = suppress;
    }
}

