/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.util;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.junit.JUnitCore;

public class CoreTestSearchEngine {
    public static boolean isTestOrTestSuite(IType declaringType) throws CoreException {
        ITestKind testKind = TestKindRegistry.getContainerTestKind((IJavaElement)declaringType);
        return testKind.getFinder().isTest(declaringType);
    }

    public static boolean isAccessibleClass(IType type, String testKindId) throws JavaModelException {
        int flags = type.getFlags();
        if (Flags.isInterface((int)flags)) {
            return false;
        }
        IJavaElement parent = type.getParent();
        while (!(parent instanceof ICompilationUnit) && !(parent instanceof IClassFile)) {
            if (!(parent instanceof IType)) {
                return false;
            }
            if ("org.eclipse.jdt.junit.loader.junit5".equals(testKindId)) {
                if (Flags.isPrivate((int)flags)) {
                    return false;
                }
                if (!Flags.isStatic((int)flags) && !type.getAnnotation("Nested").exists()) {
                    return false;
                }
            } else if (!Flags.isStatic((int)flags) || !Flags.isPublic((int)flags)) {
                return false;
            }
            flags = ((IType)parent).getFlags();
            parent = parent.getParent();
        }
        return true;
    }

    public static boolean isAccessibleClass(IType type) throws JavaModelException {
        return CoreTestSearchEngine.isAccessibleClass(type, null);
    }

    public static boolean isAccessibleClass(ITypeBinding type) {
        if (type.isInterface()) {
            return false;
        }
        int modifiers = type.getModifiers();
        while (type.getDeclaringMethod() == null) {
            ITypeBinding declaringClass = type.getDeclaringClass();
            if (declaringClass == null) {
                return true;
            }
            if (!Modifier.isStatic((int)modifiers) || !Modifier.isPublic((int)modifiers)) {
                return false;
            }
            modifiers = declaringClass.getModifiers();
            type = declaringClass;
        }
        return false;
    }

    public static boolean hasTestCaseType(IJavaProject javaProject) {
        try {
            return javaProject != null && javaProject.findType("junit.framework.TestCase") != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static boolean hasJUnit4TestAnnotation(IJavaProject project) {
        try {
            IType type;
            if (project != null && (type = project.findType("org.junit.Test")) != null) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)type.getAncestor(3);
                IClasspathEntry cpEntry = root.getRawClasspathEntry();
                return !JUnitCore.JUNIT3_CONTAINER_PATH.equals((Object)cpEntry.getPath());
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static boolean hasJUnit5TestAnnotation(IJavaProject project) {
        try {
            if (project != null) {
                IType type = project.findType("org.junit.platform.commons.annotation.Testable");
                if (type == null) {
                    type = project.findType("org.junit.platform.suite.api.Suite");
                }
                if (type != null) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)type.getAncestor(3);
                    IClasspathEntry cpEntry = root.getRawClasspathEntry();
                    return !JUnitCore.JUNIT3_CONTAINER_PATH.equals((Object)cpEntry.getPath()) && !JUnitCore.JUNIT4_CONTAINER_PATH.equals((Object)cpEntry.getPath());
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static boolean isTestImplementor(IType type) throws JavaModelException {
        IType[] superInterfaces;
        ITypeHierarchy typeHier = type.newSupertypeHierarchy(null);
        IType[] iTypeArray = superInterfaces = typeHier.getAllInterfaces();
        int n = superInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType superInterface = iTypeArray[n2];
            if ("junit.framework.Test".equals(superInterface.getFullyQualifiedName('.'))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isTestImplementor(ITypeBinding type) {
        ITypeBinding[] interfaces;
        ITypeBinding superType = type.getSuperclass();
        if (superType != null && CoreTestSearchEngine.isTestImplementor(superType)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = interfaces = type.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding curr = iTypeBindingArray[n2];
            if ("junit.framework.Test".equals(curr.getQualifiedName()) || CoreTestSearchEngine.isTestImplementor(curr)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasSuiteMethod(IType type) throws JavaModelException {
        IMethod method = type.getMethod("suite", new String[0]);
        if (!method.exists()) {
            return false;
        }
        if (!Flags.isStatic((int)method.getFlags()) || !Flags.isPublic((int)method.getFlags())) {
            return false;
        }
        return "Test".equals(Signature.getSimpleName((String)Signature.toString((String)method.getReturnType())));
    }

    public static IRegion getRegion(IJavaElement element) throws JavaModelException {
        IRegion result = JavaCore.newRegion();
        if (element.getElementType() == 2) {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = ((IJavaProject)element).getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (!root.isArchive()) {
                    result.add((IJavaElement)root);
                }
                ++n2;
            }
        } else {
            result.add(element);
        }
        return result;
    }

    public static void findTestImplementorClasses(ITypeHierarchy typeHierarchy, IType testInterface, IRegion region, Set<IType> result) throws JavaModelException {
        IType[] subtypes;
        IType[] iTypeArray = subtypes = typeHierarchy.getAllSubtypes(testInterface);
        int n = subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            int cachedFlags = typeHierarchy.getCachedFlags(type);
            if (!Flags.isInterface((int)cachedFlags) && !Flags.isAbstract((int)cachedFlags) && region.contains((IJavaElement)type) && CoreTestSearchEngine.isAccessibleClass(type)) {
                result.add(type);
            }
            ++n2;
        }
    }

    public static void findSuiteMethods(IJavaElement element, Set<IType> result, IProgressMonitor pm) throws CoreException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element}, (int)1);
        SuiteMethodTypesCollector requestor = new SuiteMethodTypesCollector(result);
        int matchRule = 24;
        SearchPattern suitePattern = SearchPattern.createPattern((String)"suite() Test", (int)1, (int)0, (int)matchRule);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        new SearchEngine().search(suitePattern, participants, scope, (SearchRequestor)requestor, pm);
    }

    public static boolean isVersionLessThan(String version1, String version2) {
        return JavaCore.compareJavaVersions((String)version1, (String)version2) < 0;
    }

    public static boolean is50OrHigher(String compliance) {
        return !CoreTestSearchEngine.isVersionLessThan(compliance, "1.5");
    }

    public static boolean is50OrHigher(IJavaProject project) {
        String source = project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return CoreTestSearchEngine.is50OrHigher(source);
    }

    public static boolean is18OrHigher(String compliance) {
        return !CoreTestSearchEngine.isVersionLessThan(compliance, "1.8");
    }

    public static boolean is18OrHigher(IJavaProject project) {
        String source = project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return CoreTestSearchEngine.is18OrHigher(source);
    }

    private static class SuiteMethodTypesCollector
    extends SearchRequestor {
        private Collection<IType> fResult;

        public SuiteMethodTypesCollector(Collection<IType> result) {
            this.fResult = result;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object enclosingElement = match.getElement();
            if (!(enclosingElement instanceof IMethod)) {
                return;
            }
            IMethod method = (IMethod)enclosingElement;
            if (!Flags.isStatic((int)method.getFlags()) || !Flags.isPublic((int)method.getFlags())) {
                return;
            }
            IType declaringType = ((IMethod)enclosingElement).getDeclaringType();
            if (!CoreTestSearchEngine.isAccessibleClass(declaringType)) {
                return;
            }
            this.fResult.add(declaringType);
        }
    }
}

