/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.cheatsheets;

import java.net.URL;
import org.eclipse.help.ui.internal.views.HelpTray;
import org.eclipse.help.ui.internal.views.IHelpPart;
import org.eclipse.help.ui.internal.views.IHelpPartPage;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.internal.cheatsheets.state.DefaultStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetHelpPart;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetView;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;

public final class OpenCheatSheetAction
extends Action {
    private String id;
    private String name;
    private URL url;
    private String xml;
    private String basePath;
    private Shell targetShell;

    public OpenCheatSheetAction(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    public OpenCheatSheetAction(String id, String name, URL url) {
        if (id == null || name == null || url == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = name;
        this.url = url;
    }

    public OpenCheatSheetAction(String id, String name, String xml, URL baseURL) {
        if (id == null || name == null || xml == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = name;
        this.xml = xml;
        if (baseURL != null) {
            this.basePath = baseURL.toExternalForm();
        }
    }

    public void run() {
        Shell shell = this.getShell();
        if (shell != null && !shell.isFocusControl() && shell.getData() instanceof TrayDialog) {
            TrayDialog dialog = (TrayDialog)shell.getData();
            HelpTray tray = (HelpTray)dialog.getTray();
            if (tray == null) {
                tray = new HelpTray();
                dialog.openTray((DialogTray)tray);
            }
            ReusableHelpPart helpPart = tray.getHelpPart();
            IHelpPartPage page = helpPart.createPage("cheatsheet-page", null, null);
            page.setVerticalSpacing(0);
            page.setHorizontalMargin(0);
            CheatSheetElement contentElement = CheatSheetRegistryReader.getInstance().findCheatSheet(this.id);
            helpPart.addPart("cheatsheet-page", (IHelpPart)new CheatSheetHelpPart(helpPart.getForm().getForm().getBody(), helpPart.getForm().getToolkit(), page.getToolBarManager(), contentElement, new DefaultStateManager()));
            page.addPart("cheatsheet-page", true);
            helpPart.addPage(page);
            helpPart.showPage("cheatsheet-page");
        } else {
            CheatSheetView view = ViewUtilities.showCheatSheetView();
            if (view == null) {
                return;
            }
            if (this.url != null) {
                view.setInput(this.id, this.name, this.url);
            } else if (this.xml != null) {
                view.setInputFromXml(this.id, this.name, this.xml, this.basePath);
            } else {
                view.setInput(this.id);
            }
            IWorkbenchPage page = view.getSite().getWorkbenchWindow().getActivePage();
            page.bringToTop((IWorkbenchPart)view);
        }
    }

    public void setTargetShell(Shell shell) {
        this.targetShell = shell;
    }

    private Shell getShell() {
        Shell shell = this.targetShell;
        if (shell == null) {
            shell = Display.getDefault().getActiveShell();
        }
        return shell;
    }
}

