/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.ejb;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.builtin.InjectionPointBean;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.injection.ForwardingInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

class SessionBeanAwareInjectionPointBean
extends InjectionPointBean {
    private static final ThreadLocal<Set<Class<?>>> CONTEXTUAL_SESSION_BEANS = new ThreadLocal<Set<Class<?>>>(){

        @Override
        protected Set<Class<?>> initialValue() {
            return new HashSet();
        }
    };

    SessionBeanAwareInjectionPointBean(BeanManagerImpl manager) {
        super(manager);
    }

    @Override
    protected InjectionPoint newInstance(InjectionPoint ip, CreationalContext<InjectionPoint> creationalContext) {
        if ((ip = super.newInstance(ip, creationalContext)) != null) {
            ip = SessionBeanAwareInjectionPointBean.wrapIfNecessary(ip);
        }
        return ip;
    }

    public static void registerContextualInstance(EjbDescriptor<?> descriptor) {
        CONTEXTUAL_SESSION_BEANS.get().add(descriptor.getBeanClass());
    }

    public static void unregisterContextualInstance(EjbDescriptor<?> descriptor) {
        Set<Class<?>> classes = CONTEXTUAL_SESSION_BEANS.get();
        classes.remove(descriptor.getBeanClass());
        if (classes.isEmpty()) {
            CONTEXTUAL_SESSION_BEANS.remove();
        }
    }

    public static InjectionPoint wrapIfNecessary(InjectionPoint ip) {
        if (ip.getBean() instanceof SessionBean && !CONTEXTUAL_SESSION_BEANS.get().contains(ip.getBean().getBeanClass())) {
            return new NonContextualSessionBeanInjectionPoint(ip);
        }
        return ip;
    }

    private static class NonContextualSessionBeanInjectionPoint
    extends ForwardingInjectionPoint
    implements Serializable {
        private static final long serialVersionUID = 6338875301221129389L;
        private final InjectionPoint delegate;

        public NonContextualSessionBeanInjectionPoint(InjectionPoint delegate) {
            this.delegate = delegate;
        }

        @Override
        protected InjectionPoint delegate() {
            return this.delegate;
        }

        @Override
        public Bean<?> getBean() {
            return null;
        }
    }
}

