/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.sql.BatchUpdateException;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import javax.transaction.xa.XAException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Utils;

class ExceptionFormatter {
    ExceptionFormatter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printTrace(SqlException sqlException, PrintWriter printWriter, String string, boolean bl) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            while (sqlException != null) {
                Sqlca sqlca;
                String string2 = string + "[SQLException@" + Integer.toHexString(sqlException.hashCode()) + "]";
                printWriter.println(string2 + " java.sql.SQLException");
                Throwable throwable = sqlException.getCause();
                if (throwable != null) {
                    ExceptionFormatter.printTrace(throwable, printWriter, string2);
                }
                if ((sqlca = sqlException.getSqlca()) != null) {
                    ExceptionFormatter.printTrace(sqlca, printWriter, string2);
                    sqlca.returnTokensOnlyInMessageText(bl);
                }
                printWriter.println(string2 + " SQL state  = " + sqlException.getSQLState());
                printWriter.println(string2 + " Error code = " + String.valueOf(sqlException.getErrorCode()));
                if (sqlException.getSqlca() == null) {
                    printWriter.println(string2 + " Message    = " + sqlException.getMessage());
                } else {
                    sqlca = sqlException.getSqlca();
                    if (bl) {
                        printWriter.println(string2 + " Tokens     = " + sqlca.getSqlErrmc());
                    } else {
                        String string3 = sqlException.getMessage();
                        if (!sqlca.messageTextRetrievedContainsTokensOnly_) {
                            printWriter.println(string2 + " Message    = " + string3);
                        } else {
                            SqlException sqlException2 = sqlca.exceptionThrownOnStoredProcInvocation_;
                            if (sqlException2 != null && (sqlException2.getErrorCode() == -440 || sqlException2.getErrorCode() == -444)) {
                                printWriter.println(string2 + " Unable to obtain message text from server. Only message tokens are available. The stored procedure SYSIBM.SQLCAMESSAGE is not installed on server. Contact your DBA.");
                            } else {
                                printWriter.println(string2 + " Error occurred while trying to obtain message text from server. Only message tokens are available.");
                            }
                            printWriter.println(string2 + " Tokens     = " + string3);
                        }
                    }
                }
                printWriter.println(string2 + " Stack trace follows");
                sqlException.printStackTrace(printWriter);
                sqlca = sqlException.getSqlca();
                if (sqlca != null) {
                    sqlca.returnTokensOnlyInMessageText(false);
                }
                sqlException = sqlException.getNextException();
            }
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printTrace(SQLException sQLException, PrintWriter printWriter, String string, boolean bl) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            while (sQLException != null) {
                String string2;
                if (sQLException instanceof DataTruncation) {
                    string2 = string + "[DataTruncation@" + Integer.toHexString(sQLException.hashCode()) + "]";
                    printWriter.println(string2 + " java.sql.DataTruncation");
                } else if (sQLException instanceof SQLWarning) {
                    string2 = string + "[SQLWarning@" + Integer.toHexString(sQLException.hashCode()) + "]";
                    printWriter.println(string2 + " java.sql.SQLWarning");
                } else if (sQLException instanceof BatchUpdateException) {
                    string2 = string + "[BatchUpdateException@" + Integer.toHexString(sQLException.hashCode()) + "]";
                    printWriter.println(string2 + " java.sql.BatchUpdateException");
                } else {
                    string2 = string + "[SQLException@" + Integer.toHexString(sQLException.hashCode()) + "]";
                    printWriter.println(string2 + " java.sql.SQLException");
                }
                printWriter.println(string2 + " SQL state  = " + sQLException.getSQLState());
                printWriter.println(string2 + " Error code = " + String.valueOf(sQLException.getErrorCode()));
                printWriter.println(string2 + " Message    = " + sQLException.getMessage());
                if (sQLException instanceof DataTruncation) {
                    printWriter.println(string2 + " Index         = " + ((DataTruncation)sQLException).getIndex());
                    printWriter.println(string2 + " Parameter     = " + ((DataTruncation)sQLException).getParameter());
                    printWriter.println(string2 + " Read          = " + ((DataTruncation)sQLException).getRead());
                    printWriter.println(string2 + " Data size     = " + ((DataTruncation)sQLException).getDataSize());
                    printWriter.println(string2 + " Transfer size = " + ((DataTruncation)sQLException).getTransferSize());
                }
                if (sQLException instanceof BatchUpdateException) {
                    printWriter.println(string2 + " Update counts = " + Utils.getStringFromInts(((BatchUpdateException)sQLException).getUpdateCounts()));
                }
                printWriter.println(string2 + " Stack trace follows");
                sQLException.printStackTrace(printWriter);
                sQLException = sQLException.getNextException();
            }
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printTrace(Sqlca sqlca, PrintWriter printWriter, String string) {
        String string2 = string + "[Sqlca@" + Integer.toHexString(sqlca.hashCode()) + "]";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(string2 + " DERBY SQLCA from server");
            printWriter.println(string2 + " SqlCode        = " + sqlca.getSqlCode());
            printWriter.println(string2 + " SqlErrd        = " + sqlca.formatSqlErrd());
            printWriter.println(string2 + " SqlErrmc       = " + sqlca.getSqlErrmc());
            printWriter.println(string2 + " SqlErrp        = " + sqlca.getSqlErrp());
            printWriter.println(string2 + " SqlState       = " + sqlca.getSqlState());
            printWriter.println(string2 + " SqlWarn        = " + sqlca.getSqlWarn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printTrace(Throwable throwable, PrintWriter printWriter, String string) {
        String string2 = string + "[Throwable@" + Integer.toHexString(throwable.hashCode()) + "]";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(string2 + " " + throwable.getClass().getName());
            printWriter.println(string2 + " Message = " + throwable.getMessage());
            printWriter.println(string2 + " Stack trace follows");
            throwable.printStackTrace(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printTrace(XAException xAException, PrintWriter printWriter, String string) {
        String string2 = string + "[XAException@" + Integer.toHexString(xAException.hashCode()) + "]";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(string2 + " javax.transaction.xa.XAException");
            printWriter.println(string2 + " Message = " + xAException.getMessage());
            printWriter.println(string2 + " Stack trace follows");
            xAException.printStackTrace(printWriter);
        }
    }
}

