/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.Indent;
import org.jboss.jdeparser.SourceFileWriter;

class StringJExpr
extends AbstractJExpr {
    private final String val;
    static final Indent ESC = new Indent(){

        @Override
        public void addIndent(Indent next, FormatPreferences preferences, StringBuilder lineBuffer) {
            next.addIndent(next, preferences, lineBuffer);
            lineBuffer.append('\"');
        }

        @Override
        public void escape(Indent next, StringBuilder b, int idx) {
            int i = idx;
            block9: while (i < b.length()) {
                char c = b.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        b.insert(i, '\\');
                        i += 2;
                        continue block9;
                    }
                    case '\n': {
                        b.replace(i, i + 1, "\\n");
                        i += 2;
                        continue block9;
                    }
                    case '\r': {
                        b.replace(i, i + 1, "\\r");
                        i += 2;
                        continue block9;
                    }
                    case '\t': {
                        b.replace(i, i + 1, "\\t");
                        i += 2;
                        continue block9;
                    }
                    case '\b': {
                        b.replace(i, i + 1, "\\b");
                        i += 2;
                        continue block9;
                    }
                    case '\f': {
                        b.replace(i, i + 1, "\\f");
                        i += 2;
                        continue block9;
                    }
                    case '\u0000': {
                        b.replace(i, i + 1, "\\0");
                        i += 2;
                        continue block9;
                    }
                }
                ++i;
            }
        }

        @Override
        public void unescaped(Indent next, StringBuilder b, int idx) {
            next.escape(next, b, idx);
        }
    };

    StringJExpr(String val) {
        super(0);
        this.val = val;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        writer.addWordSpace();
        writer.writeEscaped('\"');
        writer.pushIndent(ESC);
        try {
            writer.writeEscaped(this.val);
        }
        finally {
            writer.popIndent(ESC);
        }
        writer.writeEscaped('\"');
    }
}

